/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot;

import com.beust.jcommander.JCommander;
import io.fabric8.updatebot.Configuration;
import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.commands.CommandSupport;
import io.fabric8.updatebot.commands.Help;
import io.fabric8.updatebot.commands.ParentContext;
import io.fabric8.updatebot.commands.PullVersionChanges;
import io.fabric8.updatebot.commands.PushSourceChanges;
import io.fabric8.updatebot.commands.PushVersionChanges;
import io.fabric8.updatebot.commands.UpdatePullRequests;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateBot {
    private Configuration config = new Configuration();
    private CommandSupport lastCommend;
    private UpdatePullRequests updatePullRequests = new UpdatePullRequests();
    private Logger LOG;

    public static void main(String[] args) {
        try {
            new UpdateBot().run(args);
        }
        catch (IOException e) {
            System.err.println("Failed: " + e);
            e.printStackTrace();
            Throwable cause = e.getCause();
            if (cause != e) {
                System.out.println("Caused by: " + cause);
                cause.printStackTrace();
            }
            System.exit(1);
        }
    }

    public static CommandSupport parseCommand(String[] args, Configuration config, boolean defaultToHelp) {
        PushSourceChanges pushSourceChanges = new PushSourceChanges();
        PushVersionChanges pushVersionChanges = new PushVersionChanges();
        PullVersionChanges pullVersionChanges = new PullVersionChanges();
        UpdatePullRequests updatePullRequests = new UpdatePullRequests();
        Help help = new Help();
        JCommander commander = JCommander.newBuilder().addObject((Object)config).addCommand("help", (Object)help, new String[0]).addCommand("pull", (Object)pullVersionChanges, new String[0]).addCommand("push", (Object)pushSourceChanges, new String[0]).addCommand("push-version", (Object)pushVersionChanges, new String[0]).addCommand("update", (Object)updatePullRequests, new String[0]).build();
        commander.setExpandAtSign(false);
        commander.setProgramName("updatebot");
        commander.parse(args);
        help.setCommander(commander);
        String parsedCommand = commander.getParsedCommand();
        if (parsedCommand != null) {
            switch (parsedCommand) {
                case "help": {
                    return help;
                }
                case "pull": {
                    return pullVersionChanges;
                }
                case "push": {
                    return pushSourceChanges;
                }
                case "push-version": {
                    return pushVersionChanges;
                }
                case "update": {
                    return updatePullRequests;
                }
            }
        }
        if (defaultToHelp) {
            return help;
        }
        return null;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public void setLoggerOutput(PrintStream out) {
        this.getConfig().setPrintStream(out);
    }

    public CommandSupport run(String[] args) throws IOException {
        CommandSupport command;
        this.lastCommend = command = UpdateBot.parseCommand(args, this.config, true);
        command.run(this.config);
        return command;
    }

    public List<Map<String, String>> poll() throws IOException {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        ParentContext context = this.updatePullRequests.run(this.getConfig());
        List<CommandContext> children = context.getChildren();
        for (CommandContext child : children) {
            Map<String, String> map = child.createStatusMap();
            answer.add(map);
        }
        this.getLOG().debug("Polled " + answer);
        return answer;
    }

    public Logger getLOG() {
        if (this.LOG == null) {
            this.LOG = LoggerFactory.getLogger(UpdateBot.class);
        }
        return this.LOG;
    }

    public CommandSupport getLastCommend() {
        return this.lastCommend;
    }
}

