/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot;

import com.beust.jcommander.Parameter;
import io.fabric8.updatebot.git.GitPlugin;
import io.fabric8.updatebot.git.GitPluginCLI;
import io.fabric8.updatebot.kind.npm.DefaultNpmDependencyTreeGenerator;
import io.fabric8.updatebot.kind.npm.NpmDependencyTreeGenerator;
import io.fabric8.updatebot.support.Strings;
import io.fabric8.updatebot.support.Systems;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.github.AbuseLimitHandler;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.RateLimitHandler;
import org.slf4j.Logger;

public class Configuration {
    public GitPlugin git = new GitPluginCLI(this);
    @Parameter(names={"--github-pr-label", "-ghl"}, description="GitHub Pull Request Label")
    private String githubPullRequestLabel = Systems.getConfigValue("UPDATEBOT_GITHUB_PR_LABEL", "updatebot");
    @Parameter(names={"--dry"}, description="Dry Run mode does not perform any git commits")
    private boolean dryRun = Systems.isConfigFlag("UPDATEBOT_DRY_RUN");
    private GitHub github;
    @Parameter(names={"--config", "-c"}, description="Location of the UpdateBot YAML configuration file")
    private String configFile = Systems.getConfigValue("UPDATEBOT_CONFIG_FILE", ".updatebot.yml");
    @Parameter(names={"--work-dir", "-wd"}, description="The work directory where other downstream projects are cloned")
    private String workDir = Systems.getConfigValue("UPDATEBOT_WORK_DIR", "./.updatebot-repos");
    @Parameter(names={"--github-username", "-ghu"}, description="GitHub Username")
    private String githubUsername = Systems.getConfigValue("UPDATEBOT_GITHUB_USER");
    @Parameter(names={"--github-password", "-ghp"}, description="GitHub Password")
    private String githubPassword = Systems.getConfigValue("UPDATEBOT_GITHUB_PASSWORD");
    @Parameter(names={"--github-token", "-ght"}, description="GitHub Token")
    private String githubToken = Systems.getConfigValue("UPDATEBOT_GITHUB_TOKEN");
    @Parameter(names={"--check"}, description="Whether or not we should check dependencies are valid before submitting Pull Requests", arity=1)
    private boolean checkDependencies = true;
    @Parameter(names={"--dir", "-d"}, description="The source directory containing the git clone of the source to process")
    private String sourcePath;
    private File sourceDir;
    private boolean rebaseMode = true;
    private NpmDependencyTreeGenerator npmDependencyTreeGenerator = new DefaultNpmDependencyTreeGenerator();
    private boolean pullDisabled;
    private Map<String, String> pollStatusCache = new TreeMap<String, String>();
    private PrintStream printStream;

    public GitHub getGithub() throws IOException {
        if (this.github == null) {
            GitHubBuilder ghb = new GitHubBuilder();
            String username = this.getGithubUsername();
            String password = this.getGithubPassword();
            String token = this.getGithubToken();
            if (Strings.notEmpty(username) && Strings.notEmpty(password)) {
                ghb.withPassword(username, password);
            } else if (Strings.notEmpty(token)) {
                if (Strings.notEmpty(username)) {
                    ghb.withOAuthToken(token, username);
                } else {
                    ghb.withOAuthToken(token);
                }
            }
            ghb.withRateLimitHandler(RateLimitHandler.WAIT).withAbuseLimitHandler(AbuseLimitHandler.WAIT);
            this.github = ghb.build();
        }
        return this.github;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public String getGithubUsername() {
        return this.githubUsername;
    }

    public void setGithubUsername(String githubUsername) {
        this.githubUsername = githubUsername;
    }

    public String getGithubPassword() {
        return this.githubPassword;
    }

    public void setGithubPassword(String githubPassword) {
        this.githubPassword = githubPassword;
    }

    public String getGithubToken() {
        return this.githubToken;
    }

    public void setGithubToken(String githubToken) {
        this.githubToken = githubToken;
    }

    public String getGithubPullRequestLabel() {
        return this.githubPullRequestLabel;
    }

    public void setGithubPullRequestLabel(String githubPullRequestLabel) {
        this.githubPullRequestLabel = githubPullRequestLabel;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public boolean isRebaseMode() {
        return this.rebaseMode;
    }

    public void setRebaseMode(boolean rebaseMode) {
        this.rebaseMode = rebaseMode;
    }

    public boolean isCheckDependencies() {
        return this.checkDependencies;
    }

    public void setCheckDependencies(boolean checkDependencies) {
        this.checkDependencies = checkDependencies;
    }

    public NpmDependencyTreeGenerator getNpmDependencyTreeGenerator() {
        return this.npmDependencyTreeGenerator;
    }

    public void setNpmDependencyTreeGenerator(NpmDependencyTreeGenerator npmDependencyTreeGenerator) {
        this.npmDependencyTreeGenerator = npmDependencyTreeGenerator;
    }

    public boolean isPullDisabled() {
        return this.pullDisabled;
    }

    public void setPullDisabled(boolean pullDisabled) {
        this.pullDisabled = pullDisabled;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public File getSourceDir() {
        if (this.sourceDir == null) {
            if (this.sourcePath == null) {
                this.sourcePath = ".";
            }
            this.sourceDir = new File(this.sourcePath);
            if (!this.sourceDir.exists()) {
                URI uri = null;
                try {
                    uri = new URI(this.sourcePath);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                if (uri != null) {
                    this.sourceDir = new File(uri);
                }
            }
        }
        return this.sourceDir;
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    public Map<String, String> getPollStatusCache() {
        return this.pollStatusCache;
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
    }

    public GitPlugin getGit() {
        return this.git;
    }

    public void setGit(GitPlugin git) {
        this.git = git;
    }

    public void info(Logger log, String message) {
        if (this.printStream != null) {
            this.printStream.println(message);
        } else {
            log.info(message);
        }
    }

    public void warn(Logger log, String message) {
        if (this.printStream != null) {
            this.printStream.println("WARNING: " + message);
        } else {
            log.warn(message);
        }
    }

    public void warn(Logger log, String message, Throwable e) {
        if (this.printStream != null) {
            this.printStream.println("WARNING: " + message + " " + e);
            e.printStackTrace(this.printStream);
        } else {
            log.warn(message, e);
        }
    }
}

