/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.tekton.triggers.v1alpha1.ClusterTriggerBinding;
import io.fabric8.tekton.triggers.v1alpha1.ClusterTriggerBindingBuilder;
import io.fabric8.tekton.triggers.v1alpha1.ClusterTriggerBindingFluentImpl;
import io.fabric8.tekton.triggers.v1alpha1.ClusterTriggerBindingList;
import io.fabric8.tekton.triggers.v1alpha1.ClusterTriggerBindingListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterTriggerBindingListFluentImpl<A extends ClusterTriggerBindingListFluent<A>>
extends BaseFluent<A>
implements ClusterTriggerBindingListFluent<A> {
    private String apiVersion;
    private List<ClusterTriggerBindingBuilder> items;
    private String kind;
    private ListMeta metadata;

    public ClusterTriggerBindingListFluentImpl() {
    }

    public ClusterTriggerBindingListFluentImpl(ClusterTriggerBindingList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, ClusterTriggerBinding item) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterTriggerBindingBuilder>();
        }
        ClusterTriggerBindingBuilder builder = new ClusterTriggerBindingBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, ClusterTriggerBinding item) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterTriggerBindingBuilder>();
        }
        ClusterTriggerBindingBuilder builder = new ClusterTriggerBindingBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ClusterTriggerBinding ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterTriggerBindingBuilder>();
        }
        for (ClusterTriggerBinding item : items) {
            ClusterTriggerBindingBuilder builder = new ClusterTriggerBindingBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ClusterTriggerBinding> items) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterTriggerBindingBuilder>();
        }
        for (ClusterTriggerBinding item : items) {
            ClusterTriggerBindingBuilder builder = new ClusterTriggerBindingBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ClusterTriggerBinding ... items) {
        for (ClusterTriggerBinding item : items) {
            ClusterTriggerBindingBuilder builder = new ClusterTriggerBindingBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ClusterTriggerBinding> items) {
        for (ClusterTriggerBinding item : items) {
            ClusterTriggerBindingBuilder builder = new ClusterTriggerBindingBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ClusterTriggerBindingBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ClusterTriggerBindingBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ClusterTriggerBindingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterTriggerBinding> getItems() {
        return ClusterTriggerBindingListFluentImpl.build(this.items);
    }

    @Override
    public List<ClusterTriggerBinding> buildItems() {
        return ClusterTriggerBindingListFluentImpl.build(this.items);
    }

    @Override
    public ClusterTriggerBinding buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public ClusterTriggerBinding buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ClusterTriggerBinding buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ClusterTriggerBinding buildMatchingItem(Predicate<ClusterTriggerBindingBuilder> predicate) {
        for (ClusterTriggerBindingBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ClusterTriggerBindingBuilder> predicate) {
        for (ClusterTriggerBindingBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ClusterTriggerBinding> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ClusterTriggerBindingBuilder>();
            for (ClusterTriggerBinding item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ClusterTriggerBinding ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ClusterTriggerBinding item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ClusterTriggerBindingListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ClusterTriggerBindingListFluent.ItemsNested<A> addNewItemLike(ClusterTriggerBinding item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ClusterTriggerBindingListFluent.ItemsNested<A> setNewItemLike(int index, ClusterTriggerBinding item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ClusterTriggerBindingListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ClusterTriggerBindingListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ClusterTriggerBindingListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ClusterTriggerBindingListFluent.ItemsNested<A> editMatchingItem(Predicate<ClusterTriggerBindingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterTriggerBindingListFluentImpl that = (ClusterTriggerBindingListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends ClusterTriggerBindingFluentImpl<ClusterTriggerBindingListFluent.ItemsNested<N>>
    implements ClusterTriggerBindingListFluent.ItemsNested<N>,
    Nested<N> {
        private final ClusterTriggerBindingBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, ClusterTriggerBinding item) {
            this.index = index;
            this.builder = new ClusterTriggerBindingBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ClusterTriggerBindingBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterTriggerBindingListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

