package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerTemplateBuilder extends TriggerTemplateFluentImpl<TriggerTemplateBuilder> implements VisitableBuilder<TriggerTemplate,TriggerTemplateBuilder> {

    TriggerTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerTemplateBuilder() { 
        this(true);
    }


    public TriggerTemplateBuilder(Boolean validationEnabled) { 
        this(new TriggerTemplate(), validationEnabled);
    }


    public TriggerTemplateBuilder(TriggerTemplateFluent<?> fluent) { 
        this(fluent, true);
    }


    public TriggerTemplateBuilder(TriggerTemplateFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TriggerTemplate(), validationEnabled);
    }


    public TriggerTemplateBuilder(TriggerTemplateFluent<?> fluent,TriggerTemplate instance) { 
        this(fluent, instance, true);
    }


    public TriggerTemplateBuilder(TriggerTemplateFluent<?> fluent,TriggerTemplate instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public TriggerTemplateBuilder(TriggerTemplate instance) { 
        this(instance,true);
    }


    public TriggerTemplateBuilder(TriggerTemplate instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableTriggerTemplate build() {
        EditableTriggerTemplate buildable = new EditableTriggerTemplate(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerTemplateBuilder that = (TriggerTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
