package io.fabric8.tekton.triggers.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class TriggerSpecTemplateFluentImpl<A extends TriggerSpecTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TriggerSpecTemplateFluent<A> {

    private String apiversion;
    private String name;

    public TriggerSpecTemplateFluentImpl() { 
    }


    public TriggerSpecTemplateFluentImpl(TriggerSpecTemplate instance) { 
        this.withApiversion(instance.getApiversion()); 
        this.withName(instance.getName()); 
    }


    public String getApiversion() {
        return this.apiversion;
    }

    public A withApiversion(String apiversion) {
        this.apiversion=apiversion; return (A) this;
    }

    public Boolean hasApiversion() {
        return this.apiversion != null;
    }

    public A withNewApiversion(String arg1) {
        return (A)withApiversion(new String(arg1));
    }

    public A withNewApiversion(StringBuilder arg1) {
        return (A)withApiversion(new String(arg1));
    }

    public A withNewApiversion(StringBuffer arg1) {
        return (A)withApiversion(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TriggerSpecTemplateFluentImpl that = (TriggerSpecTemplateFluentImpl) o;
        if (apiversion != null ? !apiversion.equals(that.apiversion) :that.apiversion != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiversion,  name,  super.hashCode());
    }

}
