package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerSpecTemplateBuilder extends TriggerSpecTemplateFluentImpl<TriggerSpecTemplateBuilder> implements VisitableBuilder<TriggerSpecTemplate,TriggerSpecTemplateBuilder> {

    TriggerSpecTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerSpecTemplateBuilder() { 
        this(true);
    }


    public TriggerSpecTemplateBuilder(Boolean validationEnabled) { 
        this(new TriggerSpecTemplate(), validationEnabled);
    }


    public TriggerSpecTemplateBuilder(TriggerSpecTemplateFluent<?> fluent) { 
        this(fluent, true);
    }


    public TriggerSpecTemplateBuilder(TriggerSpecTemplateFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TriggerSpecTemplate(), validationEnabled);
    }


    public TriggerSpecTemplateBuilder(TriggerSpecTemplateFluent<?> fluent,TriggerSpecTemplate instance) { 
        this(fluent, instance, true);
    }


    public TriggerSpecTemplateBuilder(TriggerSpecTemplateFluent<?> fluent,TriggerSpecTemplate instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiversion(instance.getApiversion()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }


    public TriggerSpecTemplateBuilder(TriggerSpecTemplate instance) { 
        this(instance,true);
    }


    public TriggerSpecTemplateBuilder(TriggerSpecTemplate instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiversion(instance.getApiversion()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableTriggerSpecTemplate build() {
        EditableTriggerSpecTemplate buildable = new EditableTriggerSpecTemplate(fluent.getApiversion(),fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerSpecTemplateBuilder that = (TriggerSpecTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
