package io.fabric8.tekton.triggers.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerSpecBindingFluentImpl<A extends TriggerSpecBindingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TriggerSpecBindingFluent<A> {

    private String apiversion;
    private String kind;
    private String name;
    private String ref;
    private TriggerBindingSpecBuilder spec;

    public TriggerSpecBindingFluentImpl() { 
    }


    public TriggerSpecBindingFluentImpl(TriggerSpecBinding instance) { 
        this.withApiversion(instance.getApiversion()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withRef(instance.getRef()); 
        this.withSpec(instance.getSpec()); 
    }


    public String getApiversion() {
        return this.apiversion;
    }

    public A withApiversion(String apiversion) {
        this.apiversion=apiversion; return (A) this;
    }

    public Boolean hasApiversion() {
        return this.apiversion != null;
    }

    public A withNewApiversion(String arg1) {
        return (A)withApiversion(new String(arg1));
    }

    public A withNewApiversion(StringBuilder arg1) {
        return (A)withApiversion(new String(arg1));
    }

    public A withNewApiversion(StringBuffer arg1) {
        return (A)withApiversion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getRef() {
        return this.ref;
    }

    public A withRef(String ref) {
        this.ref=ref; return (A) this;
    }

    public Boolean hasRef() {
        return this.ref != null;
    }

    public A withNewRef(String arg1) {
        return (A)withRef(new String(arg1));
    }

    public A withNewRef(StringBuilder arg1) {
        return (A)withRef(new String(arg1));
    }

    public A withNewRef(StringBuffer arg1) {
        return (A)withRef(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public TriggerBindingSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public TriggerBindingSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(TriggerBindingSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new TriggerBindingSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public TriggerSpecBindingFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public TriggerSpecBindingFluent.SpecNested<A> withNewSpecLike(TriggerBindingSpec item) {
        return new SpecNestedImpl(item);
    }

    public TriggerSpecBindingFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public TriggerSpecBindingFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new TriggerBindingSpecBuilder().build());
    }

    public TriggerSpecBindingFluent.SpecNested<A> editOrNewSpecLike(TriggerBindingSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TriggerSpecBindingFluentImpl that = (TriggerSpecBindingFluentImpl) o;
        if (apiversion != null ? !apiversion.equals(that.apiversion) :that.apiversion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (ref != null ? !ref.equals(that.ref) :that.ref != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiversion,  kind,  name,  ref,  spec,  super.hashCode());
    }

    public class SpecNestedImpl<N> extends TriggerBindingSpecFluentImpl<TriggerSpecBindingFluent.SpecNested<N>> implements TriggerSpecBindingFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TriggerBindingSpecBuilder builder;

        SpecNestedImpl(TriggerBindingSpec item) {
            this.builder = new TriggerBindingSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new TriggerBindingSpecBuilder(this);
        }

        public N and() {
             return (N) TriggerSpecBindingFluentImpl.this.withSpec(builder.build());
        }

        public N endSpec() {
             return and();
        }
    }


}
