package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerSpecBindingBuilder extends TriggerSpecBindingFluentImpl<TriggerSpecBindingBuilder> implements VisitableBuilder<TriggerSpecBinding,TriggerSpecBindingBuilder> {

    TriggerSpecBindingFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerSpecBindingBuilder() { 
        this(true);
    }


    public TriggerSpecBindingBuilder(Boolean validationEnabled) { 
        this(new TriggerSpecBinding(), validationEnabled);
    }


    public TriggerSpecBindingBuilder(TriggerSpecBindingFluent<?> fluent) { 
        this(fluent, true);
    }


    public TriggerSpecBindingBuilder(TriggerSpecBindingFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TriggerSpecBinding(), validationEnabled);
    }


    public TriggerSpecBindingBuilder(TriggerSpecBindingFluent<?> fluent,TriggerSpecBinding instance) { 
        this(fluent, instance, true);
    }


    public TriggerSpecBindingBuilder(TriggerSpecBindingFluent<?> fluent,TriggerSpecBinding instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiversion(instance.getApiversion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withName(instance.getName()); 
        fluent.withRef(instance.getRef()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }


    public TriggerSpecBindingBuilder(TriggerSpecBinding instance) { 
        this(instance,true);
    }


    public TriggerSpecBindingBuilder(TriggerSpecBinding instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiversion(instance.getApiversion()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withRef(instance.getRef()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableTriggerSpecBinding build() {
        EditableTriggerSpecBinding buildable = new EditableTriggerSpecBinding(fluent.getApiversion(),fluent.getKind(),fluent.getName(),fluent.getRef(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerSpecBindingBuilder that = (TriggerSpecBindingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
