package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerInterceptorBuilder extends TriggerInterceptorFluentImpl<TriggerInterceptorBuilder> implements VisitableBuilder<TriggerInterceptor,TriggerInterceptorBuilder> {

    TriggerInterceptorFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerInterceptorBuilder() { 
        this(true);
    }


    public TriggerInterceptorBuilder(Boolean validationEnabled) { 
        this(new TriggerInterceptor(), validationEnabled);
    }


    public TriggerInterceptorBuilder(TriggerInterceptorFluent<?> fluent) { 
        this(fluent, true);
    }


    public TriggerInterceptorBuilder(TriggerInterceptorFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TriggerInterceptor(), validationEnabled);
    }


    public TriggerInterceptorBuilder(TriggerInterceptorFluent<?> fluent,TriggerInterceptor instance) { 
        this(fluent, instance, true);
    }


    public TriggerInterceptorBuilder(TriggerInterceptorFluent<?> fluent,TriggerInterceptor instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withBitbucket(instance.getBitbucket()); 
        fluent.withCel(instance.getCel()); 
        fluent.withGithub(instance.getGithub()); 
        fluent.withGitlab(instance.getGitlab()); 
        fluent.withWebhook(instance.getWebhook()); 
        this.validationEnabled = validationEnabled; 
    }


    public TriggerInterceptorBuilder(TriggerInterceptor instance) { 
        this(instance,true);
    }


    public TriggerInterceptorBuilder(TriggerInterceptor instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withBitbucket(instance.getBitbucket()); 
        this.withCel(instance.getCel()); 
        this.withGithub(instance.getGithub()); 
        this.withGitlab(instance.getGitlab()); 
        this.withWebhook(instance.getWebhook()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableTriggerInterceptor build() {
        EditableTriggerInterceptor buildable = new EditableTriggerInterceptor(fluent.getBitbucket(),fluent.getCel(),fluent.getGithub(),fluent.getGitlab(),fluent.getWebhook());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerInterceptorBuilder that = (TriggerInterceptorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
