
package io.fabric8.tekton.triggers.v1alpha1;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "bitbucket",
    "cel",
    "github",
    "gitlab",
    "webhook"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class TriggerInterceptor implements KubernetesResource
{

    @JsonProperty("bitbucket")
    private BitbucketInterceptor bitbucket;
    @JsonProperty("cel")
    private CELInterceptor cel;
    @JsonProperty("github")
    private GitHubInterceptor github;
    @JsonProperty("gitlab")
    private GitLabInterceptor gitlab;
    @JsonProperty("webhook")
    private WebhookInterceptor webhook;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TriggerInterceptor() {
    }

    /**
     * 
     * @param github
     * @param webhook
     * @param gitlab
     * @param cel
     * @param bitbucket
     */
    public TriggerInterceptor(BitbucketInterceptor bitbucket, CELInterceptor cel, GitHubInterceptor github, GitLabInterceptor gitlab, WebhookInterceptor webhook) {
        super();
        this.bitbucket = bitbucket;
        this.cel = cel;
        this.github = github;
        this.gitlab = gitlab;
        this.webhook = webhook;
    }

    @JsonProperty("bitbucket")
    public BitbucketInterceptor getBitbucket() {
        return bitbucket;
    }

    @JsonProperty("bitbucket")
    public void setBitbucket(BitbucketInterceptor bitbucket) {
        this.bitbucket = bitbucket;
    }

    @JsonProperty("cel")
    public CELInterceptor getCel() {
        return cel;
    }

    @JsonProperty("cel")
    public void setCel(CELInterceptor cel) {
        this.cel = cel;
    }

    @JsonProperty("github")
    public GitHubInterceptor getGithub() {
        return github;
    }

    @JsonProperty("github")
    public void setGithub(GitHubInterceptor github) {
        this.github = github;
    }

    @JsonProperty("gitlab")
    public GitLabInterceptor getGitlab() {
        return gitlab;
    }

    @JsonProperty("gitlab")
    public void setGitlab(GitLabInterceptor gitlab) {
        this.gitlab = gitlab;
    }

    @JsonProperty("webhook")
    public WebhookInterceptor getWebhook() {
        return webhook;
    }

    @JsonProperty("webhook")
    public void setWebhook(WebhookInterceptor webhook) {
        this.webhook = webhook;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
