package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodTemplateBuilder extends PodTemplateFluentImpl<PodTemplateBuilder> implements VisitableBuilder<PodTemplate,PodTemplateBuilder> {

    PodTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public PodTemplateBuilder() { 
        this(true);
    }


    public PodTemplateBuilder(Boolean validationEnabled) { 
        this(new PodTemplate(), validationEnabled);
    }


    public PodTemplateBuilder(PodTemplateFluent<?> fluent) { 
        this(fluent, true);
    }


    public PodTemplateBuilder(PodTemplateFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new PodTemplate(), validationEnabled);
    }


    public PodTemplateBuilder(PodTemplateFluent<?> fluent,PodTemplate instance) { 
        this(fluent, instance, true);
    }


    public PodTemplateBuilder(PodTemplateFluent<?> fluent,PodTemplate instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withNodeSelector(instance.getNodeSelector()); 
        fluent.withTolerations(instance.getTolerations()); 
        this.validationEnabled = validationEnabled; 
    }


    public PodTemplateBuilder(PodTemplate instance) { 
        this(instance,true);
    }


    public PodTemplateBuilder(PodTemplate instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withTolerations(instance.getTolerations()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditablePodTemplate build() {
        EditablePodTemplate buildable = new EditablePodTemplate(fluent.getNodeSelector(),fluent.getTolerations());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodTemplateBuilder that = (PodTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
