package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class EventListenerTriggerFluentImpl<A extends EventListenerTriggerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EventListenerTriggerFluent<A> {

    private List<TriggerSpecBindingBuilder> bindings;
    private List<TriggerInterceptorBuilder> interceptors;
    private String name;
    private String serviceAccountName;
    private TriggerSpecTemplateBuilder template;
    private String triggerRef;

    public EventListenerTriggerFluentImpl() { 
    }


    public EventListenerTriggerFluentImpl(EventListenerTrigger instance) { 
        this.withBindings(instance.getBindings()); 
        this.withInterceptors(instance.getInterceptors()); 
        this.withName(instance.getName()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withTemplate(instance.getTemplate()); 
        this.withTriggerRef(instance.getTriggerRef()); 
    }


    public A addToBindings(int index,TriggerSpecBinding item) {
        if (this.bindings == null) {this.bindings = new ArrayList<TriggerSpecBindingBuilder>();}
        TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);_visitables.get("bindings").add(index >= 0 ? index : _visitables.get("bindings").size(), builder);this.bindings.add(index >= 0 ? index : bindings.size(), builder); return (A)this;
    }

    public A setToBindings(int index,TriggerSpecBinding item) {
        if (this.bindings == null) {this.bindings = new ArrayList<TriggerSpecBindingBuilder>();}
        TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);
        if (index < 0 || index >= _visitables.get("bindings").size()) { _visitables.get("bindings").add(builder); } else { _visitables.get("bindings").set(index, builder);}
        if (index < 0 || index >= bindings.size()) { bindings.add(builder); } else { bindings.set(index, builder);}
         return (A)this;
    }

    public A addToBindings(TriggerSpecBinding... items) {
        if (this.bindings == null) {this.bindings = new ArrayList<TriggerSpecBindingBuilder>();}
        for (TriggerSpecBinding item : items) {TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);_visitables.get("bindings").add(builder);this.bindings.add(builder);} return (A)this;
    }

    public A addAllToBindings(Collection<TriggerSpecBinding> items) {
        if (this.bindings == null) {this.bindings = new ArrayList<TriggerSpecBindingBuilder>();}
        for (TriggerSpecBinding item : items) {TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);_visitables.get("bindings").add(builder);this.bindings.add(builder);} return (A)this;
    }

    public A removeFromBindings(TriggerSpecBinding... items) {
        for (TriggerSpecBinding item : items) {TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);_visitables.get("bindings").remove(builder);if (this.bindings != null) {this.bindings.remove(builder);}} return (A)this;
    }

    public A removeAllFromBindings(Collection<TriggerSpecBinding> items) {
        for (TriggerSpecBinding item : items) {TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);_visitables.get("bindings").remove(builder);if (this.bindings != null) {this.bindings.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBindings(Predicate<TriggerSpecBindingBuilder> predicate) {
        if (bindings == null) return (A) this;
        final Iterator<TriggerSpecBindingBuilder> each = bindings.iterator();
        final List visitables = _visitables.get("bindings");
        while (each.hasNext()) {
          TriggerSpecBindingBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildBindings instead.
 * @return The buildable object.
 */
@Deprecated public List<TriggerSpecBinding> getBindings() {
        return build(bindings);
    }

    public List<TriggerSpecBinding> buildBindings() {
        return build(bindings);
    }

    public TriggerSpecBinding buildBinding(int index) {
        return this.bindings.get(index).build();
    }

    public TriggerSpecBinding buildFirstBinding() {
        return this.bindings.get(0).build();
    }

    public TriggerSpecBinding buildLastBinding() {
        return this.bindings.get(bindings.size() - 1).build();
    }

    public TriggerSpecBinding buildMatchingBinding(Predicate<TriggerSpecBindingBuilder> predicate) {
        for (TriggerSpecBindingBuilder item: bindings) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingBinding(Predicate<TriggerSpecBindingBuilder> predicate) {
        for (TriggerSpecBindingBuilder item: bindings) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withBindings(List<TriggerSpecBinding> bindings) {
        if (this.bindings != null) { _visitables.get("bindings").removeAll(this.bindings);}
        if (bindings != null) {this.bindings = new ArrayList<TriggerSpecBindingBuilder>(); for (TriggerSpecBinding item : bindings){this.addToBindings(item);}} else { this.bindings = null;} return (A) this;
    }

    public A withBindings(TriggerSpecBinding... bindings) {
        if (this.bindings != null) {this.bindings.clear();}
        if (bindings != null) {for (TriggerSpecBinding item :bindings){ this.addToBindings(item);}} return (A) this;
    }

    public Boolean hasBindings() {
        return bindings != null && !bindings.isEmpty();
    }

    public EventListenerTriggerFluent.BindingsNested<A> addNewBinding() {
        return new BindingsNestedImpl();
    }

    public EventListenerTriggerFluent.BindingsNested<A> addNewBindingLike(TriggerSpecBinding item) {
        return new BindingsNestedImpl(-1, item);
    }

    public EventListenerTriggerFluent.BindingsNested<A> setNewBindingLike(int index,TriggerSpecBinding item) {
        return new BindingsNestedImpl(index, item);
    }

    public EventListenerTriggerFluent.BindingsNested<A> editBinding(int index) {
        if (bindings.size() <= index) throw new RuntimeException("Can't edit bindings. Index exceeds size.");
        return setNewBindingLike(index, buildBinding(index));
    }

    public EventListenerTriggerFluent.BindingsNested<A> editFirstBinding() {
        if (bindings.size() == 0) throw new RuntimeException("Can't edit first bindings. The list is empty.");
        return setNewBindingLike(0, buildBinding(0));
    }

    public EventListenerTriggerFluent.BindingsNested<A> editLastBinding() {
        int index = bindings.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last bindings. The list is empty.");
        return setNewBindingLike(index, buildBinding(index));
    }

    public EventListenerTriggerFluent.BindingsNested<A> editMatchingBinding(Predicate<TriggerSpecBindingBuilder> predicate) {
        int index = -1;
        for (int i=0;i<bindings.size();i++) { 
        if (predicate.test(bindings.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching bindings. No match found.");
        return setNewBindingLike(index, buildBinding(index));
    }

    public A addToInterceptors(int index,TriggerInterceptor item) {
        if (this.interceptors == null) {this.interceptors = new ArrayList<TriggerInterceptorBuilder>();}
        TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);_visitables.get("interceptors").add(index >= 0 ? index : _visitables.get("interceptors").size(), builder);this.interceptors.add(index >= 0 ? index : interceptors.size(), builder); return (A)this;
    }

    public A setToInterceptors(int index,TriggerInterceptor item) {
        if (this.interceptors == null) {this.interceptors = new ArrayList<TriggerInterceptorBuilder>();}
        TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
        if (index < 0 || index >= _visitables.get("interceptors").size()) { _visitables.get("interceptors").add(builder); } else { _visitables.get("interceptors").set(index, builder);}
        if (index < 0 || index >= interceptors.size()) { interceptors.add(builder); } else { interceptors.set(index, builder);}
         return (A)this;
    }

    public A addToInterceptors(TriggerInterceptor... items) {
        if (this.interceptors == null) {this.interceptors = new ArrayList<TriggerInterceptorBuilder>();}
        for (TriggerInterceptor item : items) {TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);_visitables.get("interceptors").add(builder);this.interceptors.add(builder);} return (A)this;
    }

    public A addAllToInterceptors(Collection<TriggerInterceptor> items) {
        if (this.interceptors == null) {this.interceptors = new ArrayList<TriggerInterceptorBuilder>();}
        for (TriggerInterceptor item : items) {TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);_visitables.get("interceptors").add(builder);this.interceptors.add(builder);} return (A)this;
    }

    public A removeFromInterceptors(TriggerInterceptor... items) {
        for (TriggerInterceptor item : items) {TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);_visitables.get("interceptors").remove(builder);if (this.interceptors != null) {this.interceptors.remove(builder);}} return (A)this;
    }

    public A removeAllFromInterceptors(Collection<TriggerInterceptor> items) {
        for (TriggerInterceptor item : items) {TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);_visitables.get("interceptors").remove(builder);if (this.interceptors != null) {this.interceptors.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromInterceptors(Predicate<TriggerInterceptorBuilder> predicate) {
        if (interceptors == null) return (A) this;
        final Iterator<TriggerInterceptorBuilder> each = interceptors.iterator();
        final List visitables = _visitables.get("interceptors");
        while (each.hasNext()) {
          TriggerInterceptorBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildInterceptors instead.
 * @return The buildable object.
 */
@Deprecated public List<TriggerInterceptor> getInterceptors() {
        return build(interceptors);
    }

    public List<TriggerInterceptor> buildInterceptors() {
        return build(interceptors);
    }

    public TriggerInterceptor buildInterceptor(int index) {
        return this.interceptors.get(index).build();
    }

    public TriggerInterceptor buildFirstInterceptor() {
        return this.interceptors.get(0).build();
    }

    public TriggerInterceptor buildLastInterceptor() {
        return this.interceptors.get(interceptors.size() - 1).build();
    }

    public TriggerInterceptor buildMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
        for (TriggerInterceptorBuilder item: interceptors) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
        for (TriggerInterceptorBuilder item: interceptors) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withInterceptors(List<TriggerInterceptor> interceptors) {
        if (this.interceptors != null) { _visitables.get("interceptors").removeAll(this.interceptors);}
        if (interceptors != null) {this.interceptors = new ArrayList<TriggerInterceptorBuilder>(); for (TriggerInterceptor item : interceptors){this.addToInterceptors(item);}} else { this.interceptors = null;} return (A) this;
    }

    public A withInterceptors(TriggerInterceptor... interceptors) {
        if (this.interceptors != null) {this.interceptors.clear();}
        if (interceptors != null) {for (TriggerInterceptor item :interceptors){ this.addToInterceptors(item);}} return (A) this;
    }

    public Boolean hasInterceptors() {
        return interceptors != null && !interceptors.isEmpty();
    }

    public EventListenerTriggerFluent.InterceptorsNested<A> addNewInterceptor() {
        return new InterceptorsNestedImpl();
    }

    public EventListenerTriggerFluent.InterceptorsNested<A> addNewInterceptorLike(TriggerInterceptor item) {
        return new InterceptorsNestedImpl(-1, item);
    }

    public EventListenerTriggerFluent.InterceptorsNested<A> setNewInterceptorLike(int index,TriggerInterceptor item) {
        return new InterceptorsNestedImpl(index, item);
    }

    public EventListenerTriggerFluent.InterceptorsNested<A> editInterceptor(int index) {
        if (interceptors.size() <= index) throw new RuntimeException("Can't edit interceptors. Index exceeds size.");
        return setNewInterceptorLike(index, buildInterceptor(index));
    }

    public EventListenerTriggerFluent.InterceptorsNested<A> editFirstInterceptor() {
        if (interceptors.size() == 0) throw new RuntimeException("Can't edit first interceptors. The list is empty.");
        return setNewInterceptorLike(0, buildInterceptor(0));
    }

    public EventListenerTriggerFluent.InterceptorsNested<A> editLastInterceptor() {
        int index = interceptors.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last interceptors. The list is empty.");
        return setNewInterceptorLike(index, buildInterceptor(index));
    }

    public EventListenerTriggerFluent.InterceptorsNested<A> editMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
        int index = -1;
        for (int i=0;i<interceptors.size();i++) { 
        if (predicate.test(interceptors.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching interceptors. No match found.");
        return setNewInterceptorLike(index, buildInterceptor(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public TriggerSpecTemplate getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public TriggerSpecTemplate buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(TriggerSpecTemplate template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new TriggerSpecTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate() {
        return this.template != null;
    }

    public A withNewTemplate(String apiversion,String name) {
        return (A)withTemplate(new TriggerSpecTemplate(apiversion, name));
    }

    public EventListenerTriggerFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    public EventListenerTriggerFluent.TemplateNested<A> withNewTemplateLike(TriggerSpecTemplate item) {
        return new TemplateNestedImpl(item);
    }

    public EventListenerTriggerFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public EventListenerTriggerFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new TriggerSpecTemplateBuilder().build());
    }

    public EventListenerTriggerFluent.TemplateNested<A> editOrNewTemplateLike(TriggerSpecTemplate item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public String getTriggerRef() {
        return this.triggerRef;
    }

    public A withTriggerRef(String triggerRef) {
        this.triggerRef=triggerRef; return (A) this;
    }

    public Boolean hasTriggerRef() {
        return this.triggerRef != null;
    }

    public A withNewTriggerRef(String arg1) {
        return (A)withTriggerRef(new String(arg1));
    }

    public A withNewTriggerRef(StringBuilder arg1) {
        return (A)withTriggerRef(new String(arg1));
    }

    public A withNewTriggerRef(StringBuffer arg1) {
        return (A)withTriggerRef(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EventListenerTriggerFluentImpl that = (EventListenerTriggerFluentImpl) o;
        if (bindings != null ? !bindings.equals(that.bindings) :that.bindings != null) return false;
        if (interceptors != null ? !interceptors.equals(that.interceptors) :that.interceptors != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        if (triggerRef != null ? !triggerRef.equals(that.triggerRef) :that.triggerRef != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(bindings,  interceptors,  name,  serviceAccountName,  template,  triggerRef,  super.hashCode());
    }

    public class BindingsNestedImpl<N> extends TriggerSpecBindingFluentImpl<EventListenerTriggerFluent.BindingsNested<N>> implements EventListenerTriggerFluent.BindingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TriggerSpecBindingBuilder builder;
        private final int index;

        BindingsNestedImpl(int index,TriggerSpecBinding item) {
            this.index = index;
            this.builder = new TriggerSpecBindingBuilder(this, item);
        }

        BindingsNestedImpl() {
            this.index = -1;
            this.builder = new TriggerSpecBindingBuilder(this);
        }

        public N and() {
             return (N) EventListenerTriggerFluentImpl.this.setToBindings(index,builder.build());
        }

        public N endBinding() {
             return and();
        }
    }


    public class InterceptorsNestedImpl<N> extends TriggerInterceptorFluentImpl<EventListenerTriggerFluent.InterceptorsNested<N>> implements EventListenerTriggerFluent.InterceptorsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TriggerInterceptorBuilder builder;
        private final int index;

        InterceptorsNestedImpl(int index,TriggerInterceptor item) {
            this.index = index;
            this.builder = new TriggerInterceptorBuilder(this, item);
        }

        InterceptorsNestedImpl() {
            this.index = -1;
            this.builder = new TriggerInterceptorBuilder(this);
        }

        public N and() {
             return (N) EventListenerTriggerFluentImpl.this.setToInterceptors(index,builder.build());
        }

        public N endInterceptor() {
             return and();
        }
    }


    public class TemplateNestedImpl<N> extends TriggerSpecTemplateFluentImpl<EventListenerTriggerFluent.TemplateNested<N>> implements EventListenerTriggerFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TriggerSpecTemplateBuilder builder;

        TemplateNestedImpl(TriggerSpecTemplate item) {
            this.builder = new TriggerSpecTemplateBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new TriggerSpecTemplateBuilder(this);
        }

        public N and() {
             return (N) EventListenerTriggerFluentImpl.this.withTemplate(builder.build());
        }

        public N endTemplate() {
             return and();
        }
    }


}
