package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EventListenerStatusBuilder extends EventListenerStatusFluentImpl<EventListenerStatusBuilder> implements VisitableBuilder<EventListenerStatus,EventListenerStatusBuilder> {

    EventListenerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public EventListenerStatusBuilder() { 
        this(true);
    }


    public EventListenerStatusBuilder(Boolean validationEnabled) { 
        this(new EventListenerStatus(), validationEnabled);
    }


    public EventListenerStatusBuilder(EventListenerStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public EventListenerStatusBuilder(EventListenerStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new EventListenerStatus(), validationEnabled);
    }


    public EventListenerStatusBuilder(EventListenerStatusFluent<?> fluent,EventListenerStatus instance) { 
        this(fluent, instance, true);
    }


    public EventListenerStatusBuilder(EventListenerStatusFluent<?> fluent,EventListenerStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAddress(instance.getAddress()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withConfiguration(instance.getConfiguration()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        this.validationEnabled = validationEnabled; 
    }


    public EventListenerStatusBuilder(EventListenerStatus instance) { 
        this(instance,true);
    }


    public EventListenerStatusBuilder(EventListenerStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAddress(instance.getAddress()); 
        this.withConditions(instance.getConditions()); 
        this.withConfiguration(instance.getConfiguration()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableEventListenerStatus build() {
        EditableEventListenerStatus buildable = new EditableEventListenerStatus(fluent.getAddress(),fluent.getConditions(),fluent.getConfiguration(),fluent.getObservedGeneration());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EventListenerStatusBuilder that = (EventListenerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
