package io.fabric8.tekton.triggers.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class EventListenerConfigFluentImpl<A extends EventListenerConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EventListenerConfigFluent<A> {

    private String generatedName;

    public EventListenerConfigFluentImpl() { 
    }


    public EventListenerConfigFluentImpl(EventListenerConfig instance) { 
        this.withGeneratedName(instance.getGeneratedName()); 
    }


    public String getGeneratedName() {
        return this.generatedName;
    }

    public A withGeneratedName(String generatedName) {
        this.generatedName=generatedName; return (A) this;
    }

    public Boolean hasGeneratedName() {
        return this.generatedName != null;
    }

    public A withNewGeneratedName(String arg1) {
        return (A)withGeneratedName(new String(arg1));
    }

    public A withNewGeneratedName(StringBuilder arg1) {
        return (A)withGeneratedName(new String(arg1));
    }

    public A withNewGeneratedName(StringBuffer arg1) {
        return (A)withGeneratedName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EventListenerConfigFluentImpl that = (EventListenerConfigFluentImpl) o;
        if (generatedName != null ? !generatedName.equals(that.generatedName) :that.generatedName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(generatedName,  super.hashCode());
    }

}
