package io.fabric8.tekton.triggers.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class CELOverlayFluentImpl<A extends CELOverlayFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CELOverlayFluent<A> {

    private String expression;
    private String key;

    public CELOverlayFluentImpl() { 
    }


    public CELOverlayFluentImpl(CELOverlay instance) { 
        this.withExpression(instance.getExpression()); 
        this.withKey(instance.getKey()); 
    }


    public String getExpression() {
        return this.expression;
    }

    public A withExpression(String expression) {
        this.expression=expression; return (A) this;
    }

    public Boolean hasExpression() {
        return this.expression != null;
    }

    public A withNewExpression(String arg1) {
        return (A)withExpression(new String(arg1));
    }

    public A withNewExpression(StringBuilder arg1) {
        return (A)withExpression(new String(arg1));
    }

    public A withNewExpression(StringBuffer arg1) {
        return (A)withExpression(new String(arg1));
    }

    public String getKey() {
        return this.key;
    }

    public A withKey(String key) {
        this.key=key; return (A) this;
    }

    public Boolean hasKey() {
        return this.key != null;
    }

    public A withNewKey(String arg1) {
        return (A)withKey(new String(arg1));
    }

    public A withNewKey(StringBuilder arg1) {
        return (A)withKey(new String(arg1));
    }

    public A withNewKey(StringBuffer arg1) {
        return (A)withKey(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CELOverlayFluentImpl that = (CELOverlayFluentImpl) o;
        if (expression != null ? !expression.equals(that.expression) :that.expression != null) return false;
        if (key != null ? !key.equals(that.key) :that.key != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(expression,  key,  super.hashCode());
    }

}
