package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerTemplateSpecBuilder extends TriggerTemplateSpecFluentImpl<TriggerTemplateSpecBuilder> implements VisitableBuilder<TriggerTemplateSpec,TriggerTemplateSpecBuilder> {

    TriggerTemplateSpecFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerTemplateSpecBuilder() { 
        this(true);
    }


    public TriggerTemplateSpecBuilder(Boolean validationEnabled) { 
        this(new TriggerTemplateSpec(), validationEnabled);
    }


    public TriggerTemplateSpecBuilder(TriggerTemplateSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public TriggerTemplateSpecBuilder(TriggerTemplateSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TriggerTemplateSpec(), validationEnabled);
    }


    public TriggerTemplateSpecBuilder(TriggerTemplateSpecFluent<?> fluent,TriggerTemplateSpec instance) { 
        this(fluent, instance, true);
    }


    public TriggerTemplateSpecBuilder(TriggerTemplateSpecFluent<?> fluent,TriggerTemplateSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withParams(instance.getParams()); 
        fluent.withResourcetemplates(instance.getResourcetemplates()); 
        this.validationEnabled = validationEnabled; 
    }


    public TriggerTemplateSpecBuilder(TriggerTemplateSpec instance) { 
        this(instance,true);
    }


    public TriggerTemplateSpecBuilder(TriggerTemplateSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withParams(instance.getParams()); 
        this.withResourcetemplates(instance.getResourcetemplates()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableTriggerTemplateSpec build() {
        EditableTriggerTemplateSpec buildable = new EditableTriggerTemplateSpec(fluent.getParams(),fluent.getResourcetemplates());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerTemplateSpecBuilder that = (TriggerTemplateSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
