package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerBindingBuilder extends TriggerBindingFluentImpl<TriggerBindingBuilder> implements VisitableBuilder<TriggerBinding,TriggerBindingBuilder> {

    TriggerBindingFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerBindingBuilder() { 
        this(true);
    }


    public TriggerBindingBuilder(Boolean validationEnabled) { 
        this(new TriggerBinding(), validationEnabled);
    }


    public TriggerBindingBuilder(TriggerBindingFluent<?> fluent) { 
        this(fluent, true);
    }


    public TriggerBindingBuilder(TriggerBindingFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TriggerBinding(), validationEnabled);
    }


    public TriggerBindingBuilder(TriggerBindingFluent<?> fluent,TriggerBinding instance) { 
        this(fluent, instance, true);
    }


    public TriggerBindingBuilder(TriggerBindingFluent<?> fluent,TriggerBinding instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public TriggerBindingBuilder(TriggerBinding instance) { 
        this(instance,true);
    }


    public TriggerBindingBuilder(TriggerBinding instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableTriggerBinding build() {
        EditableTriggerBinding buildable = new EditableTriggerBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerBindingBuilder that = (TriggerBindingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
