package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ParamBuilder extends ParamFluentImpl<ParamBuilder> implements VisitableBuilder<io.fabric8.tekton.triggers.v1alpha1.Param,ParamBuilder> {

    ParamFluent<?> fluent;
    Boolean validationEnabled;

    public ParamBuilder() { 
        this(true);
    }


    public ParamBuilder(Boolean validationEnabled) { 
        this(new Param(), validationEnabled);
    }


    public ParamBuilder(ParamFluent<?> fluent) { 
        this(fluent, true);
    }


    public ParamBuilder(ParamFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new Param(), validationEnabled);
    }


    public ParamBuilder(ParamFluent<?> fluent,io.fabric8.tekton.triggers.v1alpha1.Param instance) { 
        this(fluent, instance, true);
    }


    public ParamBuilder(ParamFluent<?> fluent,io.fabric8.tekton.triggers.v1alpha1.Param instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }


    public ParamBuilder(io.fabric8.tekton.triggers.v1alpha1.Param instance) { 
        this(instance,true);
    }


    public ParamBuilder(io.fabric8.tekton.triggers.v1alpha1.Param instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableParam build() {
        EditableParam buildable = new EditableParam(fluent.getName(),fluent.getValue());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ParamBuilder that = (ParamBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
