package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface EventListenerTriggerFluent<A extends EventListenerTriggerFluent<A>> extends Fluent<A> {


    public A addToBindings(int index,TriggerSpecBinding item);
    public A setToBindings(int index,TriggerSpecBinding item);
    public A addToBindings(TriggerSpecBinding... items);
    public A addAllToBindings(Collection<TriggerSpecBinding> items);
    public A removeFromBindings(TriggerSpecBinding... items);
    public A removeAllFromBindings(Collection<TriggerSpecBinding> items);
    public A removeMatchingFromBindings(Predicate<TriggerSpecBindingBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildBindings instead.
 * @return The buildable object.
 */
@Deprecated public List<TriggerSpecBinding> getBindings();
    public List<TriggerSpecBinding> buildBindings();
    public TriggerSpecBinding buildBinding(int index);
    public TriggerSpecBinding buildFirstBinding();
    public TriggerSpecBinding buildLastBinding();
    public TriggerSpecBinding buildMatchingBinding(Predicate<TriggerSpecBindingBuilder> predicate);
    public Boolean hasMatchingBinding(Predicate<TriggerSpecBindingBuilder> predicate);
    public A withBindings(List<TriggerSpecBinding> bindings);
    public A withBindings(TriggerSpecBinding... bindings);
    public Boolean hasBindings();
    public EventListenerTriggerFluent.BindingsNested<A> addNewBinding();
    public EventListenerTriggerFluent.BindingsNested<A> addNewBindingLike(TriggerSpecBinding item);
    public EventListenerTriggerFluent.BindingsNested<A> setNewBindingLike(int index,TriggerSpecBinding item);
    public EventListenerTriggerFluent.BindingsNested<A> editBinding(int index);
    public EventListenerTriggerFluent.BindingsNested<A> editFirstBinding();
    public EventListenerTriggerFluent.BindingsNested<A> editLastBinding();
    public EventListenerTriggerFluent.BindingsNested<A> editMatchingBinding(Predicate<TriggerSpecBindingBuilder> predicate);
    public A addToInterceptors(int index,TriggerInterceptor item);
    public A setToInterceptors(int index,TriggerInterceptor item);
    public A addToInterceptors(TriggerInterceptor... items);
    public A addAllToInterceptors(Collection<TriggerInterceptor> items);
    public A removeFromInterceptors(TriggerInterceptor... items);
    public A removeAllFromInterceptors(Collection<TriggerInterceptor> items);
    public A removeMatchingFromInterceptors(Predicate<TriggerInterceptorBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildInterceptors instead.
 * @return The buildable object.
 */
@Deprecated public List<TriggerInterceptor> getInterceptors();
    public List<TriggerInterceptor> buildInterceptors();
    public TriggerInterceptor buildInterceptor(int index);
    public TriggerInterceptor buildFirstInterceptor();
    public TriggerInterceptor buildLastInterceptor();
    public TriggerInterceptor buildMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate);
    public Boolean hasMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate);
    public A withInterceptors(List<TriggerInterceptor> interceptors);
    public A withInterceptors(TriggerInterceptor... interceptors);
    public Boolean hasInterceptors();
    public EventListenerTriggerFluent.InterceptorsNested<A> addNewInterceptor();
    public EventListenerTriggerFluent.InterceptorsNested<A> addNewInterceptorLike(TriggerInterceptor item);
    public EventListenerTriggerFluent.InterceptorsNested<A> setNewInterceptorLike(int index,TriggerInterceptor item);
    public EventListenerTriggerFluent.InterceptorsNested<A> editInterceptor(int index);
    public EventListenerTriggerFluent.InterceptorsNested<A> editFirstInterceptor();
    public EventListenerTriggerFluent.InterceptorsNested<A> editLastInterceptor();
    public EventListenerTriggerFluent.InterceptorsNested<A> editMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public Boolean hasServiceAccountName();
    public A withNewServiceAccountName(String arg1);
    public A withNewServiceAccountName(StringBuilder arg1);
    public A withNewServiceAccountName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public TriggerSpecTemplate getTemplate();
    public TriggerSpecTemplate buildTemplate();
    public A withTemplate(TriggerSpecTemplate template);
    public Boolean hasTemplate();
    public A withNewTemplate(String apiversion,String name);
    public EventListenerTriggerFluent.TemplateNested<A> withNewTemplate();
    public EventListenerTriggerFluent.TemplateNested<A> withNewTemplateLike(TriggerSpecTemplate item);
    public EventListenerTriggerFluent.TemplateNested<A> editTemplate();
    public EventListenerTriggerFluent.TemplateNested<A> editOrNewTemplate();
    public EventListenerTriggerFluent.TemplateNested<A> editOrNewTemplateLike(TriggerSpecTemplate item);
    public String getTriggerRef();
    public A withTriggerRef(String triggerRef);
    public Boolean hasTriggerRef();
    public A withNewTriggerRef(String arg1);
    public A withNewTriggerRef(StringBuilder arg1);
    public A withNewTriggerRef(StringBuffer arg1);
    public interface BindingsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TriggerSpecBindingFluent<EventListenerTriggerFluent.BindingsNested<N>> {

        public N and();
        public N endBinding();    }


    public interface InterceptorsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TriggerInterceptorFluent<EventListenerTriggerFluent.InterceptorsNested<N>> {

        public N and();
        public N endInterceptor();    }


    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TriggerSpecTemplateFluent<EventListenerTriggerFluent.TemplateNested<N>> {

        public N and();
        public N endTemplate();    }


}
