package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface EventListenerListFluent<A extends EventListenerListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,EventListener item);
    public A setToItems(int index,EventListener item);
    public A addToItems(EventListener... items);
    public A addAllToItems(Collection<EventListener> items);
    public A removeFromItems(EventListener... items);
    public A removeAllFromItems(Collection<EventListener> items);
    public A removeMatchingFromItems(Predicate<EventListenerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<EventListener> getItems();
    public List<EventListener> buildItems();
    public EventListener buildItem(int index);
    public EventListener buildFirstItem();
    public EventListener buildLastItem();
    public EventListener buildMatchingItem(Predicate<EventListenerBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<EventListenerBuilder> predicate);
    public A withItems(List<EventListener> items);
    public A withItems(EventListener... items);
    public Boolean hasItems();
    public EventListenerListFluent.ItemsNested<A> addNewItem();
    public EventListenerListFluent.ItemsNested<A> addNewItemLike(EventListener item);
    public EventListenerListFluent.ItemsNested<A> setNewItemLike(int index,EventListener item);
    public EventListenerListFluent.ItemsNested<A> editItem(int index);
    public EventListenerListFluent.ItemsNested<A> editFirstItem();
    public EventListenerListFluent.ItemsNested<A> editLastItem();
    public EventListenerListFluent.ItemsNested<A> editMatchingItem(Predicate<EventListenerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EventListenerFluent<EventListenerListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
