package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EventListenerListBuilder extends EventListenerListFluentImpl<EventListenerListBuilder> implements VisitableBuilder<EventListenerList,EventListenerListBuilder> {

    EventListenerListFluent<?> fluent;
    Boolean validationEnabled;

    public EventListenerListBuilder() { 
        this(true);
    }


    public EventListenerListBuilder(Boolean validationEnabled) { 
        this(new EventListenerList(), validationEnabled);
    }


    public EventListenerListBuilder(EventListenerListFluent<?> fluent) { 
        this(fluent, true);
    }


    public EventListenerListBuilder(EventListenerListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new EventListenerList(), validationEnabled);
    }


    public EventListenerListBuilder(EventListenerListFluent<?> fluent,EventListenerList instance) { 
        this(fluent, instance, true);
    }


    public EventListenerListBuilder(EventListenerListFluent<?> fluent,EventListenerList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public EventListenerListBuilder(EventListenerList instance) { 
        this(instance,true);
    }


    public EventListenerListBuilder(EventListenerList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableEventListenerList build() {
        EditableEventListenerList buildable = new EditableEventListenerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EventListenerListBuilder that = (EventListenerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
