package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EventListenerConfigBuilder extends EventListenerConfigFluentImpl<EventListenerConfigBuilder> implements VisitableBuilder<EventListenerConfig,EventListenerConfigBuilder> {

    EventListenerConfigFluent<?> fluent;
    Boolean validationEnabled;

    public EventListenerConfigBuilder() { 
        this(true);
    }


    public EventListenerConfigBuilder(Boolean validationEnabled) { 
        this(new EventListenerConfig(), validationEnabled);
    }


    public EventListenerConfigBuilder(EventListenerConfigFluent<?> fluent) { 
        this(fluent, true);
    }


    public EventListenerConfigBuilder(EventListenerConfigFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new EventListenerConfig(), validationEnabled);
    }


    public EventListenerConfigBuilder(EventListenerConfigFluent<?> fluent,EventListenerConfig instance) { 
        this(fluent, instance, true);
    }


    public EventListenerConfigBuilder(EventListenerConfigFluent<?> fluent,EventListenerConfig instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withGeneratedName(instance.getGeneratedName()); 
        this.validationEnabled = validationEnabled; 
    }


    public EventListenerConfigBuilder(EventListenerConfig instance) { 
        this(instance,true);
    }


    public EventListenerConfigBuilder(EventListenerConfig instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withGeneratedName(instance.getGeneratedName()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableEventListenerConfig build() {
        EditableEventListenerConfig buildable = new EditableEventListenerConfig(fluent.getGeneratedName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EventListenerConfigBuilder that = (EventListenerConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
