package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterTriggerBindingBuilder extends ClusterTriggerBindingFluentImpl<ClusterTriggerBindingBuilder> implements VisitableBuilder<ClusterTriggerBinding,ClusterTriggerBindingBuilder> {

    ClusterTriggerBindingFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterTriggerBindingBuilder() { 
        this(true);
    }


    public ClusterTriggerBindingBuilder(Boolean validationEnabled) { 
        this(new ClusterTriggerBinding(), validationEnabled);
    }


    public ClusterTriggerBindingBuilder(ClusterTriggerBindingFluent<?> fluent) { 
        this(fluent, true);
    }


    public ClusterTriggerBindingBuilder(ClusterTriggerBindingFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ClusterTriggerBinding(), validationEnabled);
    }


    public ClusterTriggerBindingBuilder(ClusterTriggerBindingFluent<?> fluent,ClusterTriggerBinding instance) { 
        this(fluent, instance, true);
    }


    public ClusterTriggerBindingBuilder(ClusterTriggerBindingFluent<?> fluent,ClusterTriggerBinding instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public ClusterTriggerBindingBuilder(ClusterTriggerBinding instance) { 
        this(instance,true);
    }


    public ClusterTriggerBindingBuilder(ClusterTriggerBinding instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableClusterTriggerBinding build() {
        EditableClusterTriggerBinding buildable = new EditableClusterTriggerBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterTriggerBindingBuilder that = (ClusterTriggerBindingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
