package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CELOverlayBuilder extends CELOverlayFluentImpl<CELOverlayBuilder> implements VisitableBuilder<CELOverlay,CELOverlayBuilder> {

    CELOverlayFluent<?> fluent;
    Boolean validationEnabled;

    public CELOverlayBuilder() { 
        this(true);
    }


    public CELOverlayBuilder(Boolean validationEnabled) { 
        this(new CELOverlay(), validationEnabled);
    }


    public CELOverlayBuilder(CELOverlayFluent<?> fluent) { 
        this(fluent, true);
    }


    public CELOverlayBuilder(CELOverlayFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new CELOverlay(), validationEnabled);
    }


    public CELOverlayBuilder(CELOverlayFluent<?> fluent,CELOverlay instance) { 
        this(fluent, instance, true);
    }


    public CELOverlayBuilder(CELOverlayFluent<?> fluent,CELOverlay instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withExpression(instance.getExpression()); 
        fluent.withKey(instance.getKey()); 
        this.validationEnabled = validationEnabled; 
    }


    public CELOverlayBuilder(CELOverlay instance) { 
        this(instance,true);
    }


    public CELOverlayBuilder(CELOverlay instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withExpression(instance.getExpression()); 
        this.withKey(instance.getKey()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableCELOverlay build() {
        EditableCELOverlay buildable = new EditableCELOverlay(fluent.getExpression(),fluent.getKey());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CELOverlayBuilder that = (CELOverlayBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
