package io.fabric8.tekton.triggers.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface BitbucketInterceptorFluent<A extends BitbucketInterceptorFluent<A>> extends Fluent<A> {


    public A addToEventTypes(int index,String item);
    public A setToEventTypes(int index,String item);
    public A addToEventTypes(String... items);
    public A addAllToEventTypes(Collection<String> items);
    public A removeFromEventTypes(String... items);
    public A removeAllFromEventTypes(Collection<String> items);
    public List<String> getEventTypes();
    public String getEventType(int index);
    public String getFirstEventType();
    public String getLastEventType();
    public String getMatchingEventType(Predicate<String> predicate);
    public Boolean hasMatchingEventType(Predicate<String> predicate);
    public A withEventTypes(List<String> eventTypes);
    public A withEventTypes(String... eventTypes);
    public Boolean hasEventTypes();
    public A addNewEventType(String arg1);
    public A addNewEventType(StringBuilder arg1);
    public A addNewEventType(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public SecretRef getSecretRef();
    public SecretRef buildSecretRef();
    public A withSecretRef(SecretRef secretRef);
    public Boolean hasSecretRef();
    public A withNewSecretRef(String namespace,String secretKey,String secretName);
    public BitbucketInterceptorFluent.SecretRefNested<A> withNewSecretRef();
    public BitbucketInterceptorFluent.SecretRefNested<A> withNewSecretRefLike(SecretRef item);
    public BitbucketInterceptorFluent.SecretRefNested<A> editSecretRef();
    public BitbucketInterceptorFluent.SecretRefNested<A> editOrNewSecretRef();
    public BitbucketInterceptorFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretRef item);
    public interface SecretRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecretRefFluent<BitbucketInterceptorFluent.SecretRefNested<N>> {

        public N and();
        public N endSecretRef();    }


}
