package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class WebhookInterceptorBuilder extends WebhookInterceptorFluentImpl<WebhookInterceptorBuilder> implements VisitableBuilder<WebhookInterceptor,WebhookInterceptorBuilder> {

    WebhookInterceptorFluent<?> fluent;
    Boolean validationEnabled;

    public WebhookInterceptorBuilder() { 
        this(true);
    }


    public WebhookInterceptorBuilder(Boolean validationEnabled) { 
        this(new WebhookInterceptor(), validationEnabled);
    }


    public WebhookInterceptorBuilder(WebhookInterceptorFluent<?> fluent) { 
        this(fluent, true);
    }


    public WebhookInterceptorBuilder(WebhookInterceptorFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new WebhookInterceptor(), validationEnabled);
    }


    public WebhookInterceptorBuilder(WebhookInterceptorFluent<?> fluent,WebhookInterceptor instance) { 
        this(fluent, instance, true);
    }


    public WebhookInterceptorBuilder(WebhookInterceptorFluent<?> fluent,WebhookInterceptor instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withHeader(instance.getHeader()); 
        fluent.withObjectRef(instance.getObjectRef()); 
        this.validationEnabled = validationEnabled; 
    }


    public WebhookInterceptorBuilder(WebhookInterceptor instance) { 
        this(instance,true);
    }


    public WebhookInterceptorBuilder(WebhookInterceptor instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withHeader(instance.getHeader()); 
        this.withObjectRef(instance.getObjectRef()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableWebhookInterceptor build() {
        EditableWebhookInterceptor buildable = new EditableWebhookInterceptor(fluent.getHeader(),fluent.getObjectRef());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        WebhookInterceptorBuilder that = (WebhookInterceptorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
