package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerTemplateStatusBuilder extends TriggerTemplateStatusFluentImpl<TriggerTemplateStatusBuilder> implements VisitableBuilder<TriggerTemplateStatus,TriggerTemplateStatusBuilder> {

    TriggerTemplateStatusFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerTemplateStatusBuilder() { 
        this(true);
    }


    public TriggerTemplateStatusBuilder(Boolean validationEnabled) { 
        this(new TriggerTemplateStatus(), validationEnabled);
    }


    public TriggerTemplateStatusBuilder(TriggerTemplateStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public TriggerTemplateStatusBuilder(TriggerTemplateStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TriggerTemplateStatus(), validationEnabled);
    }


    public TriggerTemplateStatusBuilder(TriggerTemplateStatusFluent<?> fluent,TriggerTemplateStatus instance) { 
        this(fluent, instance, true);
    }


    public TriggerTemplateStatusBuilder(TriggerTemplateStatusFluent<?> fluent,TriggerTemplateStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }


    public TriggerTemplateStatusBuilder(TriggerTemplateStatus instance) { 
        this(instance,true);
    }


    public TriggerTemplateStatusBuilder(TriggerTemplateStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableTriggerTemplateStatus build() {
        EditableTriggerTemplateStatus buildable = new EditableTriggerTemplateStatus();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerTemplateStatusBuilder that = (TriggerTemplateStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
