package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerBindingListBuilder extends TriggerBindingListFluentImpl<TriggerBindingListBuilder> implements VisitableBuilder<TriggerBindingList,TriggerBindingListBuilder> {

    TriggerBindingListFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerBindingListBuilder() { 
        this(true);
    }


    public TriggerBindingListBuilder(Boolean validationEnabled) { 
        this(new TriggerBindingList(), validationEnabled);
    }


    public TriggerBindingListBuilder(TriggerBindingListFluent<?> fluent) { 
        this(fluent, true);
    }


    public TriggerBindingListBuilder(TriggerBindingListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TriggerBindingList(), validationEnabled);
    }


    public TriggerBindingListBuilder(TriggerBindingListFluent<?> fluent,TriggerBindingList instance) { 
        this(fluent, instance, true);
    }


    public TriggerBindingListBuilder(TriggerBindingListFluent<?> fluent,TriggerBindingList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public TriggerBindingListBuilder(TriggerBindingList instance) { 
        this(instance,true);
    }


    public TriggerBindingListBuilder(TriggerBindingList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableTriggerBindingList build() {
        EditableTriggerBindingList buildable = new EditableTriggerBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerBindingListBuilder that = (TriggerBindingListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
