package io.fabric8.tekton.triggers.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class SecretRefFluentImpl<A extends SecretRefFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SecretRefFluent<A> {

    private String namespace;
    private String secretKey;
    private String secretName;

    public SecretRefFluentImpl() { 
    }


    public SecretRefFluentImpl(SecretRef instance) { 
        this.withNamespace(instance.getNamespace()); 
        this.withSecretKey(instance.getSecretKey()); 
        this.withSecretName(instance.getSecretName()); 
    }


    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    public A withNewNamespace(String arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuilder arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public A withSecretKey(String secretKey) {
        this.secretKey=secretKey; return (A) this;
    }

    public Boolean hasSecretKey() {
        return this.secretKey != null;
    }

    public A withNewSecretKey(String arg1) {
        return (A)withSecretKey(new String(arg1));
    }

    public A withNewSecretKey(StringBuilder arg1) {
        return (A)withSecretKey(new String(arg1));
    }

    public A withNewSecretKey(StringBuffer arg1) {
        return (A)withSecretKey(new String(arg1));
    }

    public String getSecretName() {
        return this.secretName;
    }

    public A withSecretName(String secretName) {
        this.secretName=secretName; return (A) this;
    }

    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    public A withNewSecretName(String arg1) {
        return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(StringBuilder arg1) {
        return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(StringBuffer arg1) {
        return (A)withSecretName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SecretRefFluentImpl that = (SecretRefFluentImpl) o;
        if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
        if (secretKey != null ? !secretKey.equals(that.secretKey) :that.secretKey != null) return false;
        if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(namespace,  secretKey,  secretName,  super.hashCode());
    }

}
