package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SecretRefBuilder extends SecretRefFluentImpl<SecretRefBuilder> implements VisitableBuilder<SecretRef,SecretRefBuilder> {

    SecretRefFluent<?> fluent;
    Boolean validationEnabled;

    public SecretRefBuilder() { 
        this(true);
    }


    public SecretRefBuilder(Boolean validationEnabled) { 
        this(new SecretRef(), validationEnabled);
    }


    public SecretRefBuilder(SecretRefFluent<?> fluent) { 
        this(fluent, true);
    }


    public SecretRefBuilder(SecretRefFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new SecretRef(), validationEnabled);
    }


    public SecretRefBuilder(SecretRefFluent<?> fluent,SecretRef instance) { 
        this(fluent, instance, true);
    }


    public SecretRefBuilder(SecretRefFluent<?> fluent,SecretRef instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withNamespace(instance.getNamespace()); 
        fluent.withSecretKey(instance.getSecretKey()); 
        fluent.withSecretName(instance.getSecretName()); 
        this.validationEnabled = validationEnabled; 
    }


    public SecretRefBuilder(SecretRef instance) { 
        this(instance,true);
    }


    public SecretRefBuilder(SecretRef instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withNamespace(instance.getNamespace()); 
        this.withSecretKey(instance.getSecretKey()); 
        this.withSecretName(instance.getSecretName()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableSecretRef build() {
        EditableSecretRef buildable = new EditableSecretRef(fluent.getNamespace(),fluent.getSecretKey(),fluent.getSecretName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SecretRefBuilder that = (SecretRefBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
