package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ParamSpecBuilder extends ParamSpecFluentImpl<ParamSpecBuilder> implements VisitableBuilder<ParamSpec,ParamSpecBuilder> {

    ParamSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ParamSpecBuilder() { 
        this(true);
    }


    public ParamSpecBuilder(Boolean validationEnabled) { 
        this(new ParamSpec(), validationEnabled);
    }


    public ParamSpecBuilder(ParamSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public ParamSpecBuilder(ParamSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ParamSpec(), validationEnabled);
    }


    public ParamSpecBuilder(ParamSpecFluent<?> fluent,ParamSpec instance) { 
        this(fluent, instance, true);
    }


    public ParamSpecBuilder(ParamSpecFluent<?> fluent,ParamSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withDefault(instance.getDefault()); 
        fluent.withDescription(instance.getDescription()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }


    public ParamSpecBuilder(ParamSpec instance) { 
        this(instance,true);
    }


    public ParamSpecBuilder(ParamSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withDefault(instance.getDefault()); 
        this.withDescription(instance.getDescription()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableParamSpec build() {
        EditableParamSpec buildable = new EditableParamSpec(fluent.getDefault(),fluent.getDescription(),fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ParamSpecBuilder that = (ParamSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
