package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitHubInterceptorBuilder extends GitHubInterceptorFluentImpl<GitHubInterceptorBuilder> implements VisitableBuilder<GitHubInterceptor,GitHubInterceptorBuilder> {

    GitHubInterceptorFluent<?> fluent;
    Boolean validationEnabled;

    public GitHubInterceptorBuilder() { 
        this(true);
    }


    public GitHubInterceptorBuilder(Boolean validationEnabled) { 
        this(new GitHubInterceptor(), validationEnabled);
    }


    public GitHubInterceptorBuilder(GitHubInterceptorFluent<?> fluent) { 
        this(fluent, true);
    }


    public GitHubInterceptorBuilder(GitHubInterceptorFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new GitHubInterceptor(), validationEnabled);
    }


    public GitHubInterceptorBuilder(GitHubInterceptorFluent<?> fluent,GitHubInterceptor instance) { 
        this(fluent, instance, true);
    }


    public GitHubInterceptorBuilder(GitHubInterceptorFluent<?> fluent,GitHubInterceptor instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withEventTypes(instance.getEventTypes()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        this.validationEnabled = validationEnabled; 
    }


    public GitHubInterceptorBuilder(GitHubInterceptor instance) { 
        this(instance,true);
    }


    public GitHubInterceptorBuilder(GitHubInterceptor instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withEventTypes(instance.getEventTypes()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableGitHubInterceptor build() {
        EditableGitHubInterceptor buildable = new EditableGitHubInterceptor(fluent.getEventTypes(),fluent.getSecretRef());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitHubInterceptorBuilder that = (GitHubInterceptorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
