
package io.fabric8.tekton.triggers.v1alpha1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "bindings",
    "interceptors",
    "name",
    "serviceAccountName",
    "template",
    "triggerRef"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class EventListenerTrigger implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("bindings")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<TriggerSpecBinding> bindings = new ArrayList<TriggerSpecBinding>();
    /**
     * 
     * 
     */
    @JsonProperty("interceptors")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<TriggerInterceptor> interceptors = new ArrayList<TriggerInterceptor>();
    /**
     * 
     * 
     */
    @JsonProperty("name")
    private String name;
    /**
     * 
     * 
     */
    @JsonProperty("serviceAccountName")
    private String serviceAccountName;
    /**
     * 
     * 
     */
    @JsonProperty("template")
    private TriggerSpecTemplate template;
    /**
     * 
     * 
     */
    @JsonProperty("triggerRef")
    private String triggerRef;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public EventListenerTrigger() {
    }

    /**
     * 
     * @param template
     * @param serviceAccountName
     * @param bindings
     * @param name
     * @param triggerRef
     * @param interceptors
     */
    public EventListenerTrigger(List<TriggerSpecBinding> bindings, List<TriggerInterceptor> interceptors, String name, String serviceAccountName, TriggerSpecTemplate template, String triggerRef) {
        this.bindings = bindings;
        this.interceptors = interceptors;
        this.name = name;
        this.serviceAccountName = serviceAccountName;
        this.template = template;
        this.triggerRef = triggerRef;
    }

    /**
     * 
     * 
     * @return
     *     The bindings
     */
    @JsonProperty("bindings")
    public List<TriggerSpecBinding> getBindings() {
        return bindings;
    }

    /**
     * 
     * 
     * @param bindings
     *     The bindings
     */
    @JsonProperty("bindings")
    public void setBindings(List<TriggerSpecBinding> bindings) {
        this.bindings = bindings;
    }

    /**
     * 
     * 
     * @return
     *     The interceptors
     */
    @JsonProperty("interceptors")
    public List<TriggerInterceptor> getInterceptors() {
        return interceptors;
    }

    /**
     * 
     * 
     * @param interceptors
     *     The interceptors
     */
    @JsonProperty("interceptors")
    public void setInterceptors(List<TriggerInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    /**
     * 
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * 
     * @return
     *     The serviceAccountName
     */
    @JsonProperty("serviceAccountName")
    public String getServiceAccountName() {
        return serviceAccountName;
    }

    /**
     * 
     * 
     * @param serviceAccountName
     *     The serviceAccountName
     */
    @JsonProperty("serviceAccountName")
    public void setServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    /**
     * 
     * 
     * @return
     *     The template
     */
    @JsonProperty("template")
    public TriggerSpecTemplate getTemplate() {
        return template;
    }

    /**
     * 
     * 
     * @param template
     *     The template
     */
    @JsonProperty("template")
    public void setTemplate(TriggerSpecTemplate template) {
        this.template = template;
    }

    /**
     * 
     * 
     * @return
     *     The triggerRef
     */
    @JsonProperty("triggerRef")
    public String getTriggerRef() {
        return triggerRef;
    }

    /**
     * 
     * 
     * @param triggerRef
     *     The triggerRef
     */
    @JsonProperty("triggerRef")
    public void setTriggerRef(String triggerRef) {
        this.triggerRef = triggerRef;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
