package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.duck.v1alpha1.AddressableFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.Condition;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.ConditionBuilder;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.ConditionFluentImpl;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.duck.v1alpha1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.duck.v1alpha1.Addressable;
import java.util.Collection;
import java.lang.Object;

public class EventListenerStatusFluentImpl<A extends EventListenerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EventListenerStatusFluent<A> {

    private AddressableBuilder address;
    private List<ConditionBuilder> conditions;
    private EventListenerConfigBuilder configuration;
    private Long observedGeneration;

    public EventListenerStatusFluentImpl() { 
    }


    public EventListenerStatusFluentImpl(EventListenerStatus instance) { 
        this.withAddress(instance.getAddress()); 
        this.withConditions(instance.getConditions()); 
        this.withConfiguration(instance.getConfiguration()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
    }


    
/**
 * This method has been deprecated, please use method buildAddress instead.
 * @return The buildable object.
 */
@Deprecated public Addressable getAddress() {
        return this.address!=null?this.address.build():null;
    }

    public Addressable buildAddress() {
        return this.address!=null?this.address.build():null;
    }

    public A withAddress(Addressable address) {
        _visitables.get("address").remove(this.address);
        if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} return (A) this;
    }

    public Boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(String hostname,String url) {
        return (A)withAddress(new Addressable(hostname, url));
    }

    public EventListenerStatusFluent.AddressNested<A> withNewAddress() {
        return new AddressNestedImpl();
    }

    public EventListenerStatusFluent.AddressNested<A> withNewAddressLike(Addressable item) {
        return new AddressNestedImpl(item);
    }

    public EventListenerStatusFluent.AddressNested<A> editAddress() {
        return withNewAddressLike(getAddress());
    }

    public EventListenerStatusFluent.AddressNested<A> editOrNewAddress() {
        return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
    }

    public EventListenerStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item) {
        return withNewAddressLike(getAddress() != null ? getAddress(): item);
    }

    public A addToConditions(int index,Condition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(Condition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items) {
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<ConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          ConditionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions() {
        return build(conditions);
    }

    public List<Condition> buildConditions() {
        return build(conditions);
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public EventListenerStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public EventListenerStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public EventListenerStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public EventListenerStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public EventListenerStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public EventListenerStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public EventListenerStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.apply(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public EventListenerConfig getConfiguration() {
        return this.configuration!=null?this.configuration.build():null;
    }

    public EventListenerConfig buildConfiguration() {
        return this.configuration!=null?this.configuration.build():null;
    }

    public A withConfiguration(EventListenerConfig configuration) {
        _visitables.get("configuration").remove(this.configuration);
        if (configuration!=null){ this.configuration= new EventListenerConfigBuilder(configuration); _visitables.get("configuration").add(this.configuration);} return (A) this;
    }

    public Boolean hasConfiguration() {
        return this.configuration != null;
    }

    public A withNewConfiguration(String generatedName) {
        return (A)withConfiguration(new EventListenerConfig(generatedName));
    }

    public EventListenerStatusFluent.ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    public EventListenerStatusFluent.ConfigurationNested<A> withNewConfigurationLike(EventListenerConfig item) {
        return new ConfigurationNestedImpl(item);
    }

    public EventListenerStatusFluent.ConfigurationNested<A> editConfiguration() {
        return withNewConfigurationLike(getConfiguration());
    }

    public EventListenerStatusFluent.ConfigurationNested<A> editOrNewConfiguration() {
        return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): new EventListenerConfigBuilder().build());
    }

    public EventListenerStatusFluent.ConfigurationNested<A> editOrNewConfigurationLike(EventListenerConfig item) {
        return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): item);
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EventListenerStatusFluentImpl that = (EventListenerStatusFluentImpl) o;
        if (address != null ? !address.equals(that.address) :that.address != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(address,  conditions,  configuration,  observedGeneration,  super.hashCode());
    }

    public class AddressNestedImpl<N> extends AddressableFluentImpl<EventListenerStatusFluent.AddressNested<N>> implements EventListenerStatusFluent.AddressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AddressableBuilder builder;

        AddressNestedImpl(Addressable item) {
            this.builder = new AddressableBuilder(this, item);
        }

        AddressNestedImpl() {
            this.builder = new AddressableBuilder(this);
        }

        public N and() {
             return (N) EventListenerStatusFluentImpl.this.withAddress(builder.build());
        }

        public N endAddress() {
             return and();
        }
    }


    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<EventListenerStatusFluent.ConditionsNested<N>> implements EventListenerStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index,Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ConditionBuilder(this);
        }

        public N and() {
             return (N) EventListenerStatusFluentImpl.this.setToConditions(index,builder.build());
        }

        public N endCondition() {
             return and();
        }
    }


    public class ConfigurationNestedImpl<N> extends EventListenerConfigFluentImpl<EventListenerStatusFluent.ConfigurationNested<N>> implements EventListenerStatusFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EventListenerConfigBuilder builder;

        ConfigurationNestedImpl(EventListenerConfig item) {
            this.builder = new EventListenerConfigBuilder(this, item);
        }

        ConfigurationNestedImpl() {
            this.builder = new EventListenerConfigBuilder(this);
        }

        public N and() {
             return (N) EventListenerStatusFluentImpl.this.withConfiguration(builder.build());
        }

        public N endConfiguration() {
             return and();
        }
    }


}
