package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EventListenerBuilder extends EventListenerFluentImpl<EventListenerBuilder> implements VisitableBuilder<EventListener,EventListenerBuilder> {

    EventListenerFluent<?> fluent;
    Boolean validationEnabled;

    public EventListenerBuilder() { 
        this(true);
    }


    public EventListenerBuilder(Boolean validationEnabled) { 
        this(new EventListener(), validationEnabled);
    }


    public EventListenerBuilder(EventListenerFluent<?> fluent) { 
        this(fluent, true);
    }


    public EventListenerBuilder(EventListenerFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new EventListener(), validationEnabled);
    }


    public EventListenerBuilder(EventListenerFluent<?> fluent,EventListener instance) { 
        this(fluent, instance, true);
    }


    public EventListenerBuilder(EventListenerFluent<?> fluent,EventListener instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public EventListenerBuilder(EventListener instance) { 
        this(instance,true);
    }


    public EventListenerBuilder(EventListener instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableEventListener build() {
        EditableEventListener buildable = new EditableEventListener(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EventListenerBuilder that = (EventListenerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
