package io.fabric8.tekton.triggers.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.tekton.pipeline.v1beta1.Param;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class WebhookInterceptorFluentImpl<A extends WebhookInterceptorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements WebhookInterceptorFluent<A> {

    private List<io.fabric8.tekton.pipeline.v1beta1.Param> header;
    private ObjectReference objectRef;

    public WebhookInterceptorFluentImpl() { 
    }


    public WebhookInterceptorFluentImpl(WebhookInterceptor instance) { 
        this.withHeader(instance.getHeader()); 
        this.withObjectRef(instance.getObjectRef()); 
    }


    public A addToHeader(int index,io.fabric8.tekton.pipeline.v1beta1.Param item) {
        if (this.header == null) {this.header = new ArrayList<Param>();}
        this.header.add(index, item);
        return (A)this;
    }

    public A setToHeader(int index,io.fabric8.tekton.pipeline.v1beta1.Param item) {
        if (this.header == null) {this.header = new ArrayList<Param>();}
        this.header.set(index, item); return (A)this;
    }

    public A addToHeader(io.fabric8.tekton.pipeline.v1beta1.Param... items) {
        if (this.header == null) {this.header = new ArrayList<Param>();}
        for (Param item : items) {this.header.add(item);} return (A)this;
    }

    public A addAllToHeader(Collection<io.fabric8.tekton.pipeline.v1beta1.Param> items) {
        if (this.header == null) {this.header = new ArrayList<Param>();}
        for (Param item : items) {this.header.add(item);} return (A)this;
    }

    public A removeFromHeader(io.fabric8.tekton.pipeline.v1beta1.Param... items) {
        for (Param item : items) {if (this.header!= null){ this.header.remove(item);}} return (A)this;
    }

    public A removeAllFromHeader(Collection<io.fabric8.tekton.pipeline.v1beta1.Param> items) {
        for (Param item : items) {if (this.header!= null){ this.header.remove(item);}} return (A)this;
    }

    public List<io.fabric8.tekton.pipeline.v1beta1.Param> getHeader() {
        return this.header;
    }

    public io.fabric8.tekton.pipeline.v1beta1.Param getHeader(int index) {
        return this.header.get(index);
    }

    public io.fabric8.tekton.pipeline.v1beta1.Param getFirstHeader() {
        return this.header.get(0);
    }

    public io.fabric8.tekton.pipeline.v1beta1.Param getLastHeader() {
        return this.header.get(header.size() - 1);
    }

    public io.fabric8.tekton.pipeline.v1beta1.Param getMatchingHeader(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.tekton.pipeline.v1beta1.Param> predicate) {
        for (Param item: header) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingHeader(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.tekton.pipeline.v1beta1.Param> predicate) {
        for (Param item: header) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withHeader(List<io.fabric8.tekton.pipeline.v1beta1.Param> header) {
        if (this.header != null) { _visitables.get("header").removeAll(this.header);}
        if (header != null) {this.header = new ArrayList<Param>(); for (Param item : header){this.addToHeader(item);}} else { this.header = null;} return (A) this;
    }

    public A withHeader(io.fabric8.tekton.pipeline.v1beta1.Param... header) {
        if (this.header != null) {this.header.clear();}
        if (header != null) {for (Param item :header){ this.addToHeader(item);}} return (A) this;
    }

    public Boolean hasHeader() {
        return header != null && !header.isEmpty();
    }

    public ObjectReference getObjectRef() {
        return this.objectRef;
    }

    public A withObjectRef(ObjectReference objectRef) {
        this.objectRef=objectRef; return (A) this;
    }

    public Boolean hasObjectRef() {
        return this.objectRef != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WebhookInterceptorFluentImpl that = (WebhookInterceptorFluentImpl) o;
        if (header != null ? !header.equals(that.header) :that.header != null) return false;
        if (objectRef != null ? !objectRef.equals(that.objectRef) :that.objectRef != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(header,  objectRef,  super.hashCode());
    }

}
