package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerTemplateListBuilder extends TriggerTemplateListFluentImpl<TriggerTemplateListBuilder> implements VisitableBuilder<TriggerTemplateList,TriggerTemplateListBuilder> {

    TriggerTemplateListFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerTemplateListBuilder() { 
        this(true);
    }


    public TriggerTemplateListBuilder(Boolean validationEnabled) { 
        this(new TriggerTemplateList(), validationEnabled);
    }


    public TriggerTemplateListBuilder(TriggerTemplateListFluent<?> fluent) { 
        this(fluent, true);
    }


    public TriggerTemplateListBuilder(TriggerTemplateListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TriggerTemplateList(), validationEnabled);
    }


    public TriggerTemplateListBuilder(TriggerTemplateListFluent<?> fluent,TriggerTemplateList instance) { 
        this(fluent, instance, true);
    }


    public TriggerTemplateListBuilder(TriggerTemplateListFluent<?> fluent,TriggerTemplateList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public TriggerTemplateListBuilder(TriggerTemplateList instance) { 
        this(instance,true);
    }


    public TriggerTemplateListBuilder(TriggerTemplateList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableTriggerTemplateList build() {
        EditableTriggerTemplateList buildable = new EditableTriggerTemplateList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerTemplateListBuilder that = (TriggerTemplateListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
