package io.fabric8.tekton.triggers.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class TriggerInterceptorFluentImpl<A extends TriggerInterceptorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TriggerInterceptorFluent<A> {

    private BitbucketInterceptorBuilder bitbucket;
    private CELInterceptorBuilder cel;
    private GitHubInterceptorBuilder github;
    private GitLabInterceptorBuilder gitlab;
    private WebhookInterceptorBuilder webhook;

    public TriggerInterceptorFluentImpl() { 
    }


    public TriggerInterceptorFluentImpl(TriggerInterceptor instance) { 
        this.withBitbucket(instance.getBitbucket()); 
        this.withCel(instance.getCel()); 
        this.withGithub(instance.getGithub()); 
        this.withGitlab(instance.getGitlab()); 
        this.withWebhook(instance.getWebhook()); 
    }


    
/**
 * This method has been deprecated, please use method buildBitbucket instead.
 * @return The buildable object.
 */
@Deprecated public BitbucketInterceptor getBitbucket() {
        return this.bitbucket!=null?this.bitbucket.build():null;
    }

    public BitbucketInterceptor buildBitbucket() {
        return this.bitbucket!=null?this.bitbucket.build():null;
    }

    public A withBitbucket(BitbucketInterceptor bitbucket) {
        _visitables.get("bitbucket").remove(this.bitbucket);
        if (bitbucket!=null){ this.bitbucket= new BitbucketInterceptorBuilder(bitbucket); _visitables.get("bitbucket").add(this.bitbucket);} return (A) this;
    }

    public Boolean hasBitbucket() {
        return this.bitbucket != null;
    }

    public TriggerInterceptorFluent.BitbucketNested<A> withNewBitbucket() {
        return new BitbucketNestedImpl();
    }

    public TriggerInterceptorFluent.BitbucketNested<A> withNewBitbucketLike(BitbucketInterceptor item) {
        return new BitbucketNestedImpl(item);
    }

    public TriggerInterceptorFluent.BitbucketNested<A> editBitbucket() {
        return withNewBitbucketLike(getBitbucket());
    }

    public TriggerInterceptorFluent.BitbucketNested<A> editOrNewBitbucket() {
        return withNewBitbucketLike(getBitbucket() != null ? getBitbucket(): new BitbucketInterceptorBuilder().build());
    }

    public TriggerInterceptorFluent.BitbucketNested<A> editOrNewBitbucketLike(BitbucketInterceptor item) {
        return withNewBitbucketLike(getBitbucket() != null ? getBitbucket(): item);
    }

    
/**
 * This method has been deprecated, please use method buildCel instead.
 * @return The buildable object.
 */
@Deprecated public CELInterceptor getCel() {
        return this.cel!=null?this.cel.build():null;
    }

    public CELInterceptor buildCel() {
        return this.cel!=null?this.cel.build():null;
    }

    public A withCel(CELInterceptor cel) {
        _visitables.get("cel").remove(this.cel);
        if (cel!=null){ this.cel= new CELInterceptorBuilder(cel); _visitables.get("cel").add(this.cel);} return (A) this;
    }

    public Boolean hasCel() {
        return this.cel != null;
    }

    public TriggerInterceptorFluent.CelNested<A> withNewCel() {
        return new CelNestedImpl();
    }

    public TriggerInterceptorFluent.CelNested<A> withNewCelLike(CELInterceptor item) {
        return new CelNestedImpl(item);
    }

    public TriggerInterceptorFluent.CelNested<A> editCel() {
        return withNewCelLike(getCel());
    }

    public TriggerInterceptorFluent.CelNested<A> editOrNewCel() {
        return withNewCelLike(getCel() != null ? getCel(): new CELInterceptorBuilder().build());
    }

    public TriggerInterceptorFluent.CelNested<A> editOrNewCelLike(CELInterceptor item) {
        return withNewCelLike(getCel() != null ? getCel(): item);
    }

    
/**
 * This method has been deprecated, please use method buildGithub instead.
 * @return The buildable object.
 */
@Deprecated public GitHubInterceptor getGithub() {
        return this.github!=null?this.github.build():null;
    }

    public GitHubInterceptor buildGithub() {
        return this.github!=null?this.github.build():null;
    }

    public A withGithub(GitHubInterceptor github) {
        _visitables.get("github").remove(this.github);
        if (github!=null){ this.github= new GitHubInterceptorBuilder(github); _visitables.get("github").add(this.github);} return (A) this;
    }

    public Boolean hasGithub() {
        return this.github != null;
    }

    public TriggerInterceptorFluent.GithubNested<A> withNewGithub() {
        return new GithubNestedImpl();
    }

    public TriggerInterceptorFluent.GithubNested<A> withNewGithubLike(GitHubInterceptor item) {
        return new GithubNestedImpl(item);
    }

    public TriggerInterceptorFluent.GithubNested<A> editGithub() {
        return withNewGithubLike(getGithub());
    }

    public TriggerInterceptorFluent.GithubNested<A> editOrNewGithub() {
        return withNewGithubLike(getGithub() != null ? getGithub(): new GitHubInterceptorBuilder().build());
    }

    public TriggerInterceptorFluent.GithubNested<A> editOrNewGithubLike(GitHubInterceptor item) {
        return withNewGithubLike(getGithub() != null ? getGithub(): item);
    }

    
/**
 * This method has been deprecated, please use method buildGitlab instead.
 * @return The buildable object.
 */
@Deprecated public GitLabInterceptor getGitlab() {
        return this.gitlab!=null?this.gitlab.build():null;
    }

    public GitLabInterceptor buildGitlab() {
        return this.gitlab!=null?this.gitlab.build():null;
    }

    public A withGitlab(GitLabInterceptor gitlab) {
        _visitables.get("gitlab").remove(this.gitlab);
        if (gitlab!=null){ this.gitlab= new GitLabInterceptorBuilder(gitlab); _visitables.get("gitlab").add(this.gitlab);} return (A) this;
    }

    public Boolean hasGitlab() {
        return this.gitlab != null;
    }

    public TriggerInterceptorFluent.GitlabNested<A> withNewGitlab() {
        return new GitlabNestedImpl();
    }

    public TriggerInterceptorFluent.GitlabNested<A> withNewGitlabLike(GitLabInterceptor item) {
        return new GitlabNestedImpl(item);
    }

    public TriggerInterceptorFluent.GitlabNested<A> editGitlab() {
        return withNewGitlabLike(getGitlab());
    }

    public TriggerInterceptorFluent.GitlabNested<A> editOrNewGitlab() {
        return withNewGitlabLike(getGitlab() != null ? getGitlab(): new GitLabInterceptorBuilder().build());
    }

    public TriggerInterceptorFluent.GitlabNested<A> editOrNewGitlabLike(GitLabInterceptor item) {
        return withNewGitlabLike(getGitlab() != null ? getGitlab(): item);
    }

    
/**
 * This method has been deprecated, please use method buildWebhook instead.
 * @return The buildable object.
 */
@Deprecated public WebhookInterceptor getWebhook() {
        return this.webhook!=null?this.webhook.build():null;
    }

    public WebhookInterceptor buildWebhook() {
        return this.webhook!=null?this.webhook.build():null;
    }

    public A withWebhook(WebhookInterceptor webhook) {
        _visitables.get("webhook").remove(this.webhook);
        if (webhook!=null){ this.webhook= new WebhookInterceptorBuilder(webhook); _visitables.get("webhook").add(this.webhook);} return (A) this;
    }

    public Boolean hasWebhook() {
        return this.webhook != null;
    }

    public TriggerInterceptorFluent.WebhookNested<A> withNewWebhook() {
        return new WebhookNestedImpl();
    }

    public TriggerInterceptorFluent.WebhookNested<A> withNewWebhookLike(WebhookInterceptor item) {
        return new WebhookNestedImpl(item);
    }

    public TriggerInterceptorFluent.WebhookNested<A> editWebhook() {
        return withNewWebhookLike(getWebhook());
    }

    public TriggerInterceptorFluent.WebhookNested<A> editOrNewWebhook() {
        return withNewWebhookLike(getWebhook() != null ? getWebhook(): new WebhookInterceptorBuilder().build());
    }

    public TriggerInterceptorFluent.WebhookNested<A> editOrNewWebhookLike(WebhookInterceptor item) {
        return withNewWebhookLike(getWebhook() != null ? getWebhook(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TriggerInterceptorFluentImpl that = (TriggerInterceptorFluentImpl) o;
        if (bitbucket != null ? !bitbucket.equals(that.bitbucket) :that.bitbucket != null) return false;
        if (cel != null ? !cel.equals(that.cel) :that.cel != null) return false;
        if (github != null ? !github.equals(that.github) :that.github != null) return false;
        if (gitlab != null ? !gitlab.equals(that.gitlab) :that.gitlab != null) return false;
        if (webhook != null ? !webhook.equals(that.webhook) :that.webhook != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(bitbucket,  cel,  github,  gitlab,  webhook,  super.hashCode());
    }

    public class BitbucketNestedImpl<N> extends BitbucketInterceptorFluentImpl<TriggerInterceptorFluent.BitbucketNested<N>> implements TriggerInterceptorFluent.BitbucketNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BitbucketInterceptorBuilder builder;

        BitbucketNestedImpl(BitbucketInterceptor item) {
            this.builder = new BitbucketInterceptorBuilder(this, item);
        }

        BitbucketNestedImpl() {
            this.builder = new BitbucketInterceptorBuilder(this);
        }

        public N and() {
             return (N) TriggerInterceptorFluentImpl.this.withBitbucket(builder.build());
        }

        public N endBitbucket() {
             return and();
        }
    }


    public class CelNestedImpl<N> extends CELInterceptorFluentImpl<TriggerInterceptorFluent.CelNested<N>> implements TriggerInterceptorFluent.CelNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CELInterceptorBuilder builder;

        CelNestedImpl(CELInterceptor item) {
            this.builder = new CELInterceptorBuilder(this, item);
        }

        CelNestedImpl() {
            this.builder = new CELInterceptorBuilder(this);
        }

        public N and() {
             return (N) TriggerInterceptorFluentImpl.this.withCel(builder.build());
        }

        public N endCel() {
             return and();
        }
    }


    public class GithubNestedImpl<N> extends GitHubInterceptorFluentImpl<TriggerInterceptorFluent.GithubNested<N>> implements TriggerInterceptorFluent.GithubNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GitHubInterceptorBuilder builder;

        GithubNestedImpl(GitHubInterceptor item) {
            this.builder = new GitHubInterceptorBuilder(this, item);
        }

        GithubNestedImpl() {
            this.builder = new GitHubInterceptorBuilder(this);
        }

        public N and() {
             return (N) TriggerInterceptorFluentImpl.this.withGithub(builder.build());
        }

        public N endGithub() {
             return and();
        }
    }


    public class GitlabNestedImpl<N> extends GitLabInterceptorFluentImpl<TriggerInterceptorFluent.GitlabNested<N>> implements TriggerInterceptorFluent.GitlabNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GitLabInterceptorBuilder builder;

        GitlabNestedImpl(GitLabInterceptor item) {
            this.builder = new GitLabInterceptorBuilder(this, item);
        }

        GitlabNestedImpl() {
            this.builder = new GitLabInterceptorBuilder(this);
        }

        public N and() {
             return (N) TriggerInterceptorFluentImpl.this.withGitlab(builder.build());
        }

        public N endGitlab() {
             return and();
        }
    }


    public class WebhookNestedImpl<N> extends WebhookInterceptorFluentImpl<TriggerInterceptorFluent.WebhookNested<N>> implements TriggerInterceptorFluent.WebhookNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final WebhookInterceptorBuilder builder;

        WebhookNestedImpl(WebhookInterceptor item) {
            this.builder = new WebhookInterceptorBuilder(this, item);
        }

        WebhookNestedImpl() {
            this.builder = new WebhookInterceptorBuilder(this);
        }

        public N and() {
             return (N) TriggerInterceptorFluentImpl.this.withWebhook(builder.build());
        }

        public N endWebhook() {
             return and();
        }
    }


}
