package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerBindingStatusBuilder extends TriggerBindingStatusFluentImpl<TriggerBindingStatusBuilder> implements VisitableBuilder<TriggerBindingStatus,TriggerBindingStatusBuilder> {

    TriggerBindingStatusFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerBindingStatusBuilder() { 
        this(true);
    }


    public TriggerBindingStatusBuilder(Boolean validationEnabled) { 
        this(new TriggerBindingStatus(), validationEnabled);
    }


    public TriggerBindingStatusBuilder(TriggerBindingStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public TriggerBindingStatusBuilder(TriggerBindingStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TriggerBindingStatus(), validationEnabled);
    }


    public TriggerBindingStatusBuilder(TriggerBindingStatusFluent<?> fluent,TriggerBindingStatus instance) { 
        this(fluent, instance, true);
    }


    public TriggerBindingStatusBuilder(TriggerBindingStatusFluent<?> fluent,TriggerBindingStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }


    public TriggerBindingStatusBuilder(TriggerBindingStatus instance) { 
        this(instance,true);
    }


    public TriggerBindingStatusBuilder(TriggerBindingStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableTriggerBindingStatus build() {
        EditableTriggerBindingStatus buildable = new EditableTriggerBindingStatus();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerBindingStatusBuilder that = (TriggerBindingStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
