package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerBindingSpecBuilder extends TriggerBindingSpecFluentImpl<TriggerBindingSpecBuilder> implements VisitableBuilder<TriggerBindingSpec,TriggerBindingSpecBuilder> {

    TriggerBindingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerBindingSpecBuilder() { 
        this(true);
    }


    public TriggerBindingSpecBuilder(Boolean validationEnabled) { 
        this(new TriggerBindingSpec(), validationEnabled);
    }


    public TriggerBindingSpecBuilder(TriggerBindingSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public TriggerBindingSpecBuilder(TriggerBindingSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TriggerBindingSpec(), validationEnabled);
    }


    public TriggerBindingSpecBuilder(TriggerBindingSpecFluent<?> fluent,TriggerBindingSpec instance) { 
        this(fluent, instance, true);
    }


    public TriggerBindingSpecBuilder(TriggerBindingSpecFluent<?> fluent,TriggerBindingSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withParams(instance.getParams()); 
        this.validationEnabled = validationEnabled; 
    }


    public TriggerBindingSpecBuilder(TriggerBindingSpec instance) { 
        this(instance,true);
    }


    public TriggerBindingSpecBuilder(TriggerBindingSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withParams(instance.getParams()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableTriggerBindingSpec build() {
        EditableTriggerBindingSpec buildable = new EditableTriggerBindingSpec(fluent.getParams());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerBindingSpecBuilder that = (TriggerBindingSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
