package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitLabInterceptorBuilder extends GitLabInterceptorFluentImpl<GitLabInterceptorBuilder> implements VisitableBuilder<GitLabInterceptor,GitLabInterceptorBuilder> {

    GitLabInterceptorFluent<?> fluent;
    Boolean validationEnabled;

    public GitLabInterceptorBuilder() { 
        this(true);
    }


    public GitLabInterceptorBuilder(Boolean validationEnabled) { 
        this(new GitLabInterceptor(), validationEnabled);
    }


    public GitLabInterceptorBuilder(GitLabInterceptorFluent<?> fluent) { 
        this(fluent, true);
    }


    public GitLabInterceptorBuilder(GitLabInterceptorFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new GitLabInterceptor(), validationEnabled);
    }


    public GitLabInterceptorBuilder(GitLabInterceptorFluent<?> fluent,GitLabInterceptor instance) { 
        this(fluent, instance, true);
    }


    public GitLabInterceptorBuilder(GitLabInterceptorFluent<?> fluent,GitLabInterceptor instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withEventTypes(instance.getEventTypes()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        this.validationEnabled = validationEnabled; 
    }


    public GitLabInterceptorBuilder(GitLabInterceptor instance) { 
        this(instance,true);
    }


    public GitLabInterceptorBuilder(GitLabInterceptor instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withEventTypes(instance.getEventTypes()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableGitLabInterceptor build() {
        EditableGitLabInterceptor buildable = new EditableGitLabInterceptor(fluent.getEventTypes(),fluent.getSecretRef());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitLabInterceptorBuilder that = (GitLabInterceptorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
