package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EventListenerTriggerBuilder extends EventListenerTriggerFluentImpl<EventListenerTriggerBuilder> implements VisitableBuilder<EventListenerTrigger,EventListenerTriggerBuilder> {

    EventListenerTriggerFluent<?> fluent;
    Boolean validationEnabled;

    public EventListenerTriggerBuilder() { 
        this(true);
    }


    public EventListenerTriggerBuilder(Boolean validationEnabled) { 
        this(new EventListenerTrigger(), validationEnabled);
    }


    public EventListenerTriggerBuilder(EventListenerTriggerFluent<?> fluent) { 
        this(fluent, true);
    }


    public EventListenerTriggerBuilder(EventListenerTriggerFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new EventListenerTrigger(), validationEnabled);
    }


    public EventListenerTriggerBuilder(EventListenerTriggerFluent<?> fluent,EventListenerTrigger instance) { 
        this(fluent, instance, true);
    }


    public EventListenerTriggerBuilder(EventListenerTriggerFluent<?> fluent,EventListenerTrigger instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withBindings(instance.getBindings()); 
        fluent.withInterceptors(instance.getInterceptors()); 
        fluent.withName(instance.getName()); 
        fluent.withServiceAccountName(instance.getServiceAccountName()); 
        fluent.withTemplate(instance.getTemplate()); 
        fluent.withTriggerRef(instance.getTriggerRef()); 
        this.validationEnabled = validationEnabled; 
    }


    public EventListenerTriggerBuilder(EventListenerTrigger instance) { 
        this(instance,true);
    }


    public EventListenerTriggerBuilder(EventListenerTrigger instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withBindings(instance.getBindings()); 
        this.withInterceptors(instance.getInterceptors()); 
        this.withName(instance.getName()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withTemplate(instance.getTemplate()); 
        this.withTriggerRef(instance.getTriggerRef()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableEventListenerTrigger build() {
        EditableEventListenerTrigger buildable = new EditableEventListenerTrigger(fluent.getBindings(),fluent.getInterceptors(),fluent.getName(),fluent.getServiceAccountName(),fluent.getTemplate(),fluent.getTriggerRef());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EventListenerTriggerBuilder that = (EventListenerTriggerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
