package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class EventListenerSpecFluentImpl<A extends EventListenerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EventListenerSpecFluent<A> {

    private PodTemplateBuilder podTemplate;
    private Integer replicas;
    private String serviceAccountName;
    private String serviceType;
    private List<EventListenerTriggerBuilder> triggers;

    public EventListenerSpecFluentImpl() { 
    }


    public EventListenerSpecFluentImpl(EventListenerSpec instance) { 
        this.withPodTemplate(instance.getPodTemplate()); 
        this.withReplicas(instance.getReplicas()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withServiceType(instance.getServiceType()); 
        this.withTriggers(instance.getTriggers()); 
    }


    
/**
 * This method has been deprecated, please use method buildPodTemplate instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplate getPodTemplate() {
        return this.podTemplate!=null?this.podTemplate.build():null;
    }

    public PodTemplate buildPodTemplate() {
        return this.podTemplate!=null?this.podTemplate.build():null;
    }

    public A withPodTemplate(PodTemplate podTemplate) {
        _visitables.get("podTemplate").remove(this.podTemplate);
        if (podTemplate!=null){ this.podTemplate= new PodTemplateBuilder(podTemplate); _visitables.get("podTemplate").add(this.podTemplate);} return (A) this;
    }

    public Boolean hasPodTemplate() {
        return this.podTemplate != null;
    }

    public EventListenerSpecFluent.PodTemplateNested<A> withNewPodTemplate() {
        return new PodTemplateNestedImpl();
    }

    public EventListenerSpecFluent.PodTemplateNested<A> withNewPodTemplateLike(PodTemplate item) {
        return new PodTemplateNestedImpl(item);
    }

    public EventListenerSpecFluent.PodTemplateNested<A> editPodTemplate() {
        return withNewPodTemplateLike(getPodTemplate());
    }

    public EventListenerSpecFluent.PodTemplateNested<A> editOrNewPodTemplate() {
        return withNewPodTemplateLike(getPodTemplate() != null ? getPodTemplate(): new PodTemplateBuilder().build());
    }

    public EventListenerSpecFluent.PodTemplateNested<A> editOrNewPodTemplateLike(PodTemplate item) {
        return withNewPodTemplateLike(getPodTemplate() != null ? getPodTemplate(): item);
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public A withServiceType(String serviceType) {
        this.serviceType=serviceType; return (A) this;
    }

    public Boolean hasServiceType() {
        return this.serviceType != null;
    }

    public A withNewServiceType(String arg1) {
        return (A)withServiceType(new String(arg1));
    }

    public A withNewServiceType(StringBuilder arg1) {
        return (A)withServiceType(new String(arg1));
    }

    public A withNewServiceType(StringBuffer arg1) {
        return (A)withServiceType(new String(arg1));
    }

    public A addToTriggers(int index,EventListenerTrigger item) {
        if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
        EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").add(index >= 0 ? index : _visitables.get("triggers").size(), builder);this.triggers.add(index >= 0 ? index : triggers.size(), builder); return (A)this;
    }

    public A setToTriggers(int index,EventListenerTrigger item) {
        if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
        EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);
        if (index < 0 || index >= _visitables.get("triggers").size()) { _visitables.get("triggers").add(builder); } else { _visitables.get("triggers").set(index, builder);}
        if (index < 0 || index >= triggers.size()) { triggers.add(builder); } else { triggers.set(index, builder);}
         return (A)this;
    }

    public A addToTriggers(EventListenerTrigger... items) {
        if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
        for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
    }

    public A addAllToTriggers(Collection<EventListenerTrigger> items) {
        if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
        for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
    }

    public A removeFromTriggers(EventListenerTrigger... items) {
        for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
    }

    public A removeAllFromTriggers(Collection<EventListenerTrigger> items) {
        for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTriggers(io.fabric8.kubernetes.api.builder.Predicate<EventListenerTriggerBuilder> predicate) {
        if (triggers == null) return (A) this;
        final Iterator<EventListenerTriggerBuilder> each = triggers.iterator();
        final List visitables = _visitables.get("triggers");
        while (each.hasNext()) {
          EventListenerTriggerBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTriggers instead.
 * @return The buildable object.
 */
@Deprecated public List<EventListenerTrigger> getTriggers() {
        return build(triggers);
    }

    public List<EventListenerTrigger> buildTriggers() {
        return build(triggers);
    }

    public EventListenerTrigger buildTrigger(int index) {
        return this.triggers.get(index).build();
    }

    public EventListenerTrigger buildFirstTrigger() {
        return this.triggers.get(0).build();
    }

    public EventListenerTrigger buildLastTrigger() {
        return this.triggers.get(triggers.size() - 1).build();
    }

    public EventListenerTrigger buildMatchingTrigger(io.fabric8.kubernetes.api.builder.Predicate<EventListenerTriggerBuilder> predicate) {
        for (EventListenerTriggerBuilder item: triggers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTrigger(io.fabric8.kubernetes.api.builder.Predicate<EventListenerTriggerBuilder> predicate) {
        for (EventListenerTriggerBuilder item: triggers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTriggers(List<EventListenerTrigger> triggers) {
        if (this.triggers != null) { _visitables.get("triggers").removeAll(this.triggers);}
        if (triggers != null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>(); for (EventListenerTrigger item : triggers){this.addToTriggers(item);}} else { this.triggers = null;} return (A) this;
    }

    public A withTriggers(EventListenerTrigger... triggers) {
        if (this.triggers != null) {this.triggers.clear();}
        if (triggers != null) {for (EventListenerTrigger item :triggers){ this.addToTriggers(item);}} return (A) this;
    }

    public Boolean hasTriggers() {
        return triggers != null && !triggers.isEmpty();
    }

    public EventListenerSpecFluent.TriggersNested<A> addNewTrigger() {
        return new TriggersNestedImpl();
    }

    public EventListenerSpecFluent.TriggersNested<A> addNewTriggerLike(EventListenerTrigger item) {
        return new TriggersNestedImpl(-1, item);
    }

    public EventListenerSpecFluent.TriggersNested<A> setNewTriggerLike(int index,EventListenerTrigger item) {
        return new TriggersNestedImpl(index, item);
    }

    public EventListenerSpecFluent.TriggersNested<A> editTrigger(int index) {
        if (triggers.size() <= index) throw new RuntimeException("Can't edit triggers. Index exceeds size.");
        return setNewTriggerLike(index, buildTrigger(index));
    }

    public EventListenerSpecFluent.TriggersNested<A> editFirstTrigger() {
        if (triggers.size() == 0) throw new RuntimeException("Can't edit first triggers. The list is empty.");
        return setNewTriggerLike(0, buildTrigger(0));
    }

    public EventListenerSpecFluent.TriggersNested<A> editLastTrigger() {
        int index = triggers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last triggers. The list is empty.");
        return setNewTriggerLike(index, buildTrigger(index));
    }

    public EventListenerSpecFluent.TriggersNested<A> editMatchingTrigger(io.fabric8.kubernetes.api.builder.Predicate<EventListenerTriggerBuilder> predicate) {
        int index = -1;
        for (int i=0;i<triggers.size();i++) { 
        if (predicate.apply(triggers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching triggers. No match found.");
        return setNewTriggerLike(index, buildTrigger(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EventListenerSpecFluentImpl that = (EventListenerSpecFluentImpl) o;
        if (podTemplate != null ? !podTemplate.equals(that.podTemplate) :that.podTemplate != null) return false;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (serviceType != null ? !serviceType.equals(that.serviceType) :that.serviceType != null) return false;
        if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(podTemplate,  replicas,  serviceAccountName,  serviceType,  triggers,  super.hashCode());
    }

    public class PodTemplateNestedImpl<N> extends PodTemplateFluentImpl<EventListenerSpecFluent.PodTemplateNested<N>> implements EventListenerSpecFluent.PodTemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodTemplateBuilder builder;

        PodTemplateNestedImpl(PodTemplate item) {
            this.builder = new PodTemplateBuilder(this, item);
        }

        PodTemplateNestedImpl() {
            this.builder = new PodTemplateBuilder(this);
        }

        public N and() {
             return (N) EventListenerSpecFluentImpl.this.withPodTemplate(builder.build());
        }

        public N endPodTemplate() {
             return and();
        }
    }


    public class TriggersNestedImpl<N> extends EventListenerTriggerFluentImpl<EventListenerSpecFluent.TriggersNested<N>> implements EventListenerSpecFluent.TriggersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EventListenerTriggerBuilder builder;
        private final int index;

        TriggersNestedImpl(int index,EventListenerTrigger item) {
            this.index = index;
            this.builder = new EventListenerTriggerBuilder(this, item);
        }

        TriggersNestedImpl() {
            this.index = -1;
            this.builder = new EventListenerTriggerBuilder(this);
        }

        public N and() {
             return (N) EventListenerSpecFluentImpl.this.setToTriggers(index,builder.build());
        }

        public N endTrigger() {
             return and();
        }
    }


}
