package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EventListenerSpecBuilder extends EventListenerSpecFluentImpl<EventListenerSpecBuilder> implements VisitableBuilder<EventListenerSpec,EventListenerSpecBuilder> {

    EventListenerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public EventListenerSpecBuilder() { 
        this(true);
    }


    public EventListenerSpecBuilder(Boolean validationEnabled) { 
        this(new EventListenerSpec(), validationEnabled);
    }


    public EventListenerSpecBuilder(EventListenerSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public EventListenerSpecBuilder(EventListenerSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new EventListenerSpec(), validationEnabled);
    }


    public EventListenerSpecBuilder(EventListenerSpecFluent<?> fluent,EventListenerSpec instance) { 
        this(fluent, instance, true);
    }


    public EventListenerSpecBuilder(EventListenerSpecFluent<?> fluent,EventListenerSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withPodTemplate(instance.getPodTemplate()); 
        fluent.withReplicas(instance.getReplicas()); 
        fluent.withServiceAccountName(instance.getServiceAccountName()); 
        fluent.withServiceType(instance.getServiceType()); 
        fluent.withTriggers(instance.getTriggers()); 
        this.validationEnabled = validationEnabled; 
    }


    public EventListenerSpecBuilder(EventListenerSpec instance) { 
        this(instance,true);
    }


    public EventListenerSpecBuilder(EventListenerSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withPodTemplate(instance.getPodTemplate()); 
        this.withReplicas(instance.getReplicas()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withServiceType(instance.getServiceType()); 
        this.withTriggers(instance.getTriggers()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableEventListenerSpec build() {
        EditableEventListenerSpec buildable = new EditableEventListenerSpec(fluent.getPodTemplate(),fluent.getReplicas(),fluent.getServiceAccountName(),fluent.getServiceType(),fluent.getTriggers());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EventListenerSpecBuilder that = (EventListenerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
