package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterTriggerBindingListBuilder extends ClusterTriggerBindingListFluentImpl<ClusterTriggerBindingListBuilder> implements VisitableBuilder<ClusterTriggerBindingList,ClusterTriggerBindingListBuilder> {

    ClusterTriggerBindingListFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterTriggerBindingListBuilder() { 
        this(true);
    }


    public ClusterTriggerBindingListBuilder(Boolean validationEnabled) { 
        this(new ClusterTriggerBindingList(), validationEnabled);
    }


    public ClusterTriggerBindingListBuilder(ClusterTriggerBindingListFluent<?> fluent) { 
        this(fluent, true);
    }


    public ClusterTriggerBindingListBuilder(ClusterTriggerBindingListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ClusterTriggerBindingList(), validationEnabled);
    }


    public ClusterTriggerBindingListBuilder(ClusterTriggerBindingListFluent<?> fluent,ClusterTriggerBindingList instance) { 
        this(fluent, instance, true);
    }


    public ClusterTriggerBindingListBuilder(ClusterTriggerBindingListFluent<?> fluent,ClusterTriggerBindingList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public ClusterTriggerBindingListBuilder(ClusterTriggerBindingList instance) { 
        this(instance,true);
    }


    public ClusterTriggerBindingListBuilder(ClusterTriggerBindingList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableClusterTriggerBindingList build() {
        EditableClusterTriggerBindingList buildable = new EditableClusterTriggerBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterTriggerBindingListBuilder that = (ClusterTriggerBindingListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
