package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CELInterceptorBuilder extends CELInterceptorFluentImpl<CELInterceptorBuilder> implements VisitableBuilder<CELInterceptor,CELInterceptorBuilder> {

    CELInterceptorFluent<?> fluent;
    Boolean validationEnabled;

    public CELInterceptorBuilder() { 
        this(true);
    }


    public CELInterceptorBuilder(Boolean validationEnabled) { 
        this(new CELInterceptor(), validationEnabled);
    }


    public CELInterceptorBuilder(CELInterceptorFluent<?> fluent) { 
        this(fluent, true);
    }


    public CELInterceptorBuilder(CELInterceptorFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new CELInterceptor(), validationEnabled);
    }


    public CELInterceptorBuilder(CELInterceptorFluent<?> fluent,CELInterceptor instance) { 
        this(fluent, instance, true);
    }


    public CELInterceptorBuilder(CELInterceptorFluent<?> fluent,CELInterceptor instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withFilter(instance.getFilter()); 
        fluent.withOverlays(instance.getOverlays()); 
        this.validationEnabled = validationEnabled; 
    }


    public CELInterceptorBuilder(CELInterceptor instance) { 
        this(instance,true);
    }


    public CELInterceptorBuilder(CELInterceptor instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withFilter(instance.getFilter()); 
        this.withOverlays(instance.getOverlays()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableCELInterceptor build() {
        EditableCELInterceptor buildable = new EditableCELInterceptor(fluent.getFilter(),fluent.getOverlays());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CELInterceptorBuilder that = (CELInterceptorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
