package io.fabric8.tekton.triggers.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class BitbucketInterceptorFluentImpl<A extends BitbucketInterceptorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BitbucketInterceptorFluent<A> {

    private List<String> eventTypes;
    private SecretRefBuilder secretRef;

    public BitbucketInterceptorFluentImpl() { 
    }


    public BitbucketInterceptorFluentImpl(BitbucketInterceptor instance) { 
        this.withEventTypes(instance.getEventTypes()); 
        this.withSecretRef(instance.getSecretRef()); 
    }


    public A addToEventTypes(int index,String item) {
        if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
        this.eventTypes.add(index, item);
        return (A)this;
    }

    public A setToEventTypes(int index,String item) {
        if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
        this.eventTypes.set(index, item); return (A)this;
    }

    public A addToEventTypes(String... items) {
        if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
        for (String item : items) {this.eventTypes.add(item);} return (A)this;
    }

    public A addAllToEventTypes(Collection<String> items) {
        if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
        for (String item : items) {this.eventTypes.add(item);} return (A)this;
    }

    public A removeFromEventTypes(String... items) {
        for (String item : items) {if (this.eventTypes!= null){ this.eventTypes.remove(item);}} return (A)this;
    }

    public A removeAllFromEventTypes(Collection<String> items) {
        for (String item : items) {if (this.eventTypes!= null){ this.eventTypes.remove(item);}} return (A)this;
    }

    public List<String> getEventTypes() {
        return this.eventTypes;
    }

    public String getEventType(int index) {
        return this.eventTypes.get(index);
    }

    public String getFirstEventType() {
        return this.eventTypes.get(0);
    }

    public String getLastEventType() {
        return this.eventTypes.get(eventTypes.size() - 1);
    }

    public String getMatchingEventType(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: eventTypes) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEventType(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: eventTypes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEventTypes(List<String> eventTypes) {
        if (this.eventTypes != null) { _visitables.get("eventTypes").removeAll(this.eventTypes);}
        if (eventTypes != null) {this.eventTypes = new ArrayList<String>(); for (String item : eventTypes){this.addToEventTypes(item);}} else { this.eventTypes = null;} return (A) this;
    }

    public A withEventTypes(String... eventTypes) {
        if (this.eventTypes != null) {this.eventTypes.clear();}
        if (eventTypes != null) {for (String item :eventTypes){ this.addToEventTypes(item);}} return (A) this;
    }

    public Boolean hasEventTypes() {
        return eventTypes != null && !eventTypes.isEmpty();
    }

    public A addNewEventType(String arg1) {
        return (A)addToEventTypes(new String(arg1));
    }

    public A addNewEventType(StringBuilder arg1) {
        return (A)addToEventTypes(new String(arg1));
    }

    public A addNewEventType(StringBuffer arg1) {
        return (A)addToEventTypes(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public SecretRef getSecretRef() {
        return this.secretRef!=null?this.secretRef.build():null;
    }

    public SecretRef buildSecretRef() {
        return this.secretRef!=null?this.secretRef.build():null;
    }

    public A withSecretRef(SecretRef secretRef) {
        _visitables.get("secretRef").remove(this.secretRef);
        if (secretRef!=null){ this.secretRef= new SecretRefBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} return (A) this;
    }

    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public A withNewSecretRef(String namespace,String secretKey,String secretName) {
        return (A)withSecretRef(new SecretRef(namespace, secretKey, secretName));
    }

    public BitbucketInterceptorFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    public BitbucketInterceptorFluent.SecretRefNested<A> withNewSecretRefLike(SecretRef item) {
        return new SecretRefNestedImpl(item);
    }

    public BitbucketInterceptorFluent.SecretRefNested<A> editSecretRef() {
        return withNewSecretRefLike(getSecretRef());
    }

    public BitbucketInterceptorFluent.SecretRefNested<A> editOrNewSecretRef() {
        return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new SecretRefBuilder().build());
    }

    public BitbucketInterceptorFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretRef item) {
        return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BitbucketInterceptorFluentImpl that = (BitbucketInterceptorFluentImpl) o;
        if (eventTypes != null ? !eventTypes.equals(that.eventTypes) :that.eventTypes != null) return false;
        if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(eventTypes,  secretRef,  super.hashCode());
    }

    public class SecretRefNestedImpl<N> extends SecretRefFluentImpl<BitbucketInterceptorFluent.SecretRefNested<N>> implements BitbucketInterceptorFluent.SecretRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretRefBuilder builder;

        SecretRefNestedImpl(SecretRef item) {
            this.builder = new SecretRefBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new SecretRefBuilder(this);
        }

        public N and() {
             return (N) BitbucketInterceptorFluentImpl.this.withSecretRef(builder.build());
        }

        public N endSecretRef() {
             return and();
        }
    }


}
