package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BitbucketInterceptorBuilder extends BitbucketInterceptorFluentImpl<BitbucketInterceptorBuilder> implements VisitableBuilder<BitbucketInterceptor,BitbucketInterceptorBuilder> {

    BitbucketInterceptorFluent<?> fluent;
    Boolean validationEnabled;

    public BitbucketInterceptorBuilder() { 
        this(true);
    }


    public BitbucketInterceptorBuilder(Boolean validationEnabled) { 
        this(new BitbucketInterceptor(), validationEnabled);
    }


    public BitbucketInterceptorBuilder(BitbucketInterceptorFluent<?> fluent) { 
        this(fluent, true);
    }


    public BitbucketInterceptorBuilder(BitbucketInterceptorFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new BitbucketInterceptor(), validationEnabled);
    }


    public BitbucketInterceptorBuilder(BitbucketInterceptorFluent<?> fluent,BitbucketInterceptor instance) { 
        this(fluent, instance, true);
    }


    public BitbucketInterceptorBuilder(BitbucketInterceptorFluent<?> fluent,BitbucketInterceptor instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withEventTypes(instance.getEventTypes()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        this.validationEnabled = validationEnabled; 
    }


    public BitbucketInterceptorBuilder(BitbucketInterceptor instance) { 
        this(instance,true);
    }


    public BitbucketInterceptorBuilder(BitbucketInterceptor instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withEventTypes(instance.getEventTypes()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.tekton.triggers.v1alpha1.EditableBitbucketInterceptor build() {
        EditableBitbucketInterceptor buildable = new EditableBitbucketInterceptor(fluent.getEventTypes(),fluent.getSecretRef());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BitbucketInterceptorBuilder that = (BitbucketInterceptorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
