/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1beta1.internal.pipeline.pkg.apis.pipeline.pod;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.tekton.v1beta1.internal.pipeline.pkg.apis.pipeline.pod.Template;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TemplateFluent<A extends TemplateFluent<A>>
extends BaseFluent<A> {
    private Affinity affinity;
    private Boolean automountServiceAccountToken;
    private PodDNSConfig dnsConfig;
    private String dnsPolicy;
    private Boolean enableServiceLinks;
    private ArrayList<EnvVarBuilder> env = new ArrayList();
    private List<HostAlias> hostAliases = new ArrayList<HostAlias>();
    private Boolean hostNetwork;
    private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList();
    private Map<String, String> nodeSelector;
    private String priorityClassName;
    private String runtimeClassName;
    private String schedulerName;
    private PodSecurityContext securityContext;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private List<TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
    private ArrayList<VolumeBuilder> volumes = new ArrayList();

    public TemplateFluent() {
    }

    public TemplateFluent(Template instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Template instance) {
        Template template = instance = instance != null ? instance : new Template();
        if (instance != null) {
            this.withAffinity(instance.getAffinity());
            this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
            this.withDnsConfig(instance.getDnsConfig());
            this.withDnsPolicy(instance.getDnsPolicy());
            this.withEnableServiceLinks(instance.getEnableServiceLinks());
            this.withEnv(instance.getEnv());
            this.withHostAliases(instance.getHostAliases());
            this.withHostNetwork(instance.getHostNetwork());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withNodeSelector(instance.getNodeSelector());
            this.withPriorityClassName(instance.getPriorityClassName());
            this.withRuntimeClassName(instance.getRuntimeClassName());
            this.withSchedulerName(instance.getSchedulerName());
            this.withSecurityContext(instance.getSecurityContext());
            this.withTolerations(instance.getTolerations());
            this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
            this.withVolumes(instance.getVolumes());
            this.withAffinity(instance.getAffinity());
            this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
            this.withDnsConfig(instance.getDnsConfig());
            this.withDnsPolicy(instance.getDnsPolicy());
            this.withEnableServiceLinks(instance.getEnableServiceLinks());
            this.withEnv(instance.getEnv());
            this.withHostAliases(instance.getHostAliases());
            this.withHostNetwork(instance.getHostNetwork());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withNodeSelector(instance.getNodeSelector());
            this.withPriorityClassName(instance.getPriorityClassName());
            this.withRuntimeClassName(instance.getRuntimeClassName());
            this.withSchedulerName(instance.getSchedulerName());
            this.withSecurityContext(instance.getSecurityContext());
            this.withTolerations(instance.getTolerations());
            this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
            this.withVolumes(instance.getVolumes());
        }
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)((Object)this);
    }

    public boolean hasAffinity() {
        return this.affinity != null;
    }

    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)((Object)this);
    }

    public boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    public PodDNSConfig getDnsConfig() {
        return this.dnsConfig;
    }

    public A withDnsConfig(PodDNSConfig dnsConfig) {
        this.dnsConfig = dnsConfig;
        return (A)((Object)this);
    }

    public boolean hasDnsConfig() {
        return this.dnsConfig != null;
    }

    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)((Object)this);
    }

    public boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    public Boolean getEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    public A withEnableServiceLinks(Boolean enableServiceLinks) {
        this.enableServiceLinks = enableServiceLinks;
        return (A)((Object)this);
    }

    public boolean hasEnableServiceLinks() {
        return this.enableServiceLinks != null;
    }

    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(index, builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").set(index, builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(EnvVar ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            this.env.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            this.env.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<EnvVarBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<EnvVar> buildEnv() {
        return this.env != null ? TemplateFluent.build(this.env) : null;
    }

    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<EnvVar> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public A addToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        this.hostAliases.add(index, item);
        return (A)((Object)this);
    }

    public A setToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        this.hostAliases.set(index, item);
        return (A)((Object)this);
    }

    public A addToHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        for (HostAlias item : items) {
            this.hostAliases.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        for (HostAlias item : items) {
            this.hostAliases.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            return (A)((Object)this);
        }
        for (HostAlias item : items) {
            this.hostAliases.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            return (A)((Object)this);
        }
        for (HostAlias item : items) {
            this.hostAliases.remove(item);
        }
        return (A)((Object)this);
    }

    public List<HostAlias> getHostAliases() {
        return this.hostAliases;
    }

    public HostAlias getHostAlias(int index) {
        return this.hostAliases.get(index);
    }

    public HostAlias getFirstHostAlias() {
        return this.hostAliases.get(0);
    }

    public HostAlias getLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1);
    }

    public HostAlias getMatchingHostAlias(Predicate<HostAlias> predicate) {
        for (HostAlias item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHostAlias(Predicate<HostAlias> predicate) {
        for (HostAlias item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHostAliases(List<HostAlias> hostAliases) {
        if (hostAliases != null) {
            this.hostAliases = new ArrayList<HostAlias>();
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        } else {
            this.hostAliases = null;
        }
        return (A)((Object)this);
    }

    public A withHostAliases(HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
            this._visitables.remove((Object)"hostAliases");
        }
        if (hostAliases != null) {
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)((Object)this);
    }

    public boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    public A addToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get((Object)"imagePullSecrets").add(index, builder);
            this.imagePullSecrets.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get((Object)"imagePullSecrets").set(index, builder);
            this.imagePullSecrets.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            return (A)((Object)this);
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            return (A)((Object)this);
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (this.imagePullSecrets == null) {
            return (A)((Object)this);
        }
        Iterator<LocalObjectReferenceBuilder> each = this.imagePullSecrets.iterator();
        List visitables = this._visitables.get((Object)"imagePullSecrets");
        while (each.hasNext()) {
            LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<LocalObjectReference> buildImagePullSecrets() {
        return this.imagePullSecrets != null ? TemplateFluent.build(this.imagePullSecrets) : null;
    }

    public LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    public LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    public LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get((Object)"imagePullSecrets").clear();
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList();
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)((Object)this);
    }

    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
            this._visitables.remove((Object)"imagePullSecrets");
        }
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    public ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNested(-1, null);
    }

    public ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNested(-1, item);
    }

    public ImagePullSecretsNested<A> setNewImagePullSecretLike(int index, LocalObjectReference item) {
        return new ImagePullSecretsNested(index, item);
    }

    public ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    public ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.test(this.imagePullSecrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)((Object)this);
    }

    public boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    public A withRuntimeClassName(String runtimeClassName) {
        this.runtimeClassName = runtimeClassName;
        return (A)((Object)this);
    }

    public boolean hasRuntimeClassName() {
        return this.runtimeClassName != null;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public A withSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return (A)((Object)this);
    }

    public boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public A withSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
        return (A)((Object)this);
    }

    public boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)((Object)this);
    }

    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)((Object)this);
    }

    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)((Object)this);
    }

    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove((Object)"tolerations");
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public A addToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.add(index, item);
        return (A)((Object)this);
    }

    public A setToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.set(index, item);
        return (A)((Object)this);
    }

    public A addToTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            return (A)((Object)this);
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            return (A)((Object)this);
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.remove(item);
        }
        return (A)((Object)this);
    }

    public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index);
    }

    public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0);
    }

    public TopologySpreadConstraint getLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1);
    }

    public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)((Object)this);
    }

    public A withTopologySpreadConstraints(TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
            this._visitables.remove((Object)"topologySpreadConstraints");
        }
        if (topologySpreadConstraints != null) {
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").add(index, builder);
            this.volumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
            this.volumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumes(Volume ... items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        Iterator<VolumeBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Volume> buildVolumes() {
        return this.volumes != null ? TemplateFluent.build(this.volumes) : null;
    }

    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").clear();
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)((Object)this);
    }

    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove((Object)"volumes");
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public VolumesNested<A> addNewVolume() {
        return new VolumesNested(-1, null);
    }

    public VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNested(-1, item);
    }

    public VolumesNested<A> setNewVolumeLike(int index, Volume item) {
        return new VolumesNested(index, item);
    }

    public VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    public VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemplateFluent that = (TemplateFluent)((Object)o);
        if (!Objects.equals(this.affinity, that.affinity)) {
            return false;
        }
        if (!Objects.equals(this.automountServiceAccountToken, that.automountServiceAccountToken)) {
            return false;
        }
        if (!Objects.equals(this.dnsConfig, that.dnsConfig)) {
            return false;
        }
        if (!Objects.equals(this.dnsPolicy, that.dnsPolicy)) {
            return false;
        }
        if (!Objects.equals(this.enableServiceLinks, that.enableServiceLinks)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.hostAliases, that.hostAliases)) {
            return false;
        }
        if (!Objects.equals(this.hostNetwork, that.hostNetwork)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecrets, that.imagePullSecrets)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.priorityClassName, that.priorityClassName)) {
            return false;
        }
        if (!Objects.equals(this.runtimeClassName, that.runtimeClassName)) {
            return false;
        }
        if (!Objects.equals(this.schedulerName, that.schedulerName)) {
            return false;
        }
        if (!Objects.equals(this.securityContext, that.securityContext)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        if (!Objects.equals(this.topologySpreadConstraints, that.topologySpreadConstraints)) {
            return false;
        }
        return Objects.equals(this.volumes, that.volumes);
    }

    public int hashCode() {
        return Objects.hash(this.affinity, this.automountServiceAccountToken, this.dnsConfig, this.dnsPolicy, this.enableServiceLinks, this.env, this.hostAliases, this.hostNetwork, this.imagePullSecrets, this.nodeSelector, this.priorityClassName, this.runtimeClassName, this.schedulerName, this.securityContext, this.tolerations, this.topologySpreadConstraints, this.volumes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.affinity != null) {
            sb.append("affinity:");
            sb.append(this.affinity + ",");
        }
        if (this.automountServiceAccountToken != null) {
            sb.append("automountServiceAccountToken:");
            sb.append(this.automountServiceAccountToken + ",");
        }
        if (this.dnsConfig != null) {
            sb.append("dnsConfig:");
            sb.append(this.dnsConfig + ",");
        }
        if (this.dnsPolicy != null) {
            sb.append("dnsPolicy:");
            sb.append(this.dnsPolicy + ",");
        }
        if (this.enableServiceLinks != null) {
            sb.append("enableServiceLinks:");
            sb.append(this.enableServiceLinks + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.hostAliases != null && !this.hostAliases.isEmpty()) {
            sb.append("hostAliases:");
            sb.append(this.hostAliases + ",");
        }
        if (this.hostNetwork != null) {
            sb.append("hostNetwork:");
            sb.append(this.hostNetwork + ",");
        }
        if (this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty()) {
            sb.append("imagePullSecrets:");
            sb.append(this.imagePullSecrets + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.priorityClassName != null) {
            sb.append("priorityClassName:");
            sb.append(this.priorityClassName + ",");
        }
        if (this.runtimeClassName != null) {
            sb.append("runtimeClassName:");
            sb.append(this.runtimeClassName + ",");
        }
        if (this.schedulerName != null) {
            sb.append("schedulerName:");
            sb.append(this.schedulerName + ",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(this.securityContext + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations + ",");
        }
        if (this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty()) {
            sb.append("topologySpreadConstraints:");
            sb.append(this.topologySpreadConstraints + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAutomountServiceAccountToken() {
        return this.withAutomountServiceAccountToken(true);
    }

    public A withEnableServiceLinks() {
        return this.withEnableServiceLinks(true);
    }

    public A withHostNetwork() {
        return this.withHostNetwork(true);
    }

    public class VolumesNested<N>
    extends VolumeFluent<VolumesNested<N>>
    implements Nested<N> {
        VolumeBuilder builder;
        int index;

        VolumesNested(int index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder((VolumeFluent)this, item);
        }

        public N and() {
            return (N)TemplateFluent.this.setToVolumes(this.index, this.builder.build());
        }

        public N endVolume() {
            return this.and();
        }
    }

    public class ImagePullSecretsNested<N>
    extends LocalObjectReferenceFluent<ImagePullSecretsNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;
        int index;

        ImagePullSecretsNested(int index, LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)TemplateFluent.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        public N endImagePullSecret() {
            return this.and();
        }
    }

    public class EnvNested<N>
    extends EnvVarFluent<EnvNested<N>>
    implements Nested<N> {
        EnvVarBuilder builder;
        int index;

        EnvNested(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder((EnvVarFluent)this, item);
        }

        public N and() {
            return (N)TemplateFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endEnv() {
            return this.and();
        }
    }
}

