/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.tekton.triggers.v1alpha1.NamespaceSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class NamespaceSelectorFluent<A extends NamespaceSelectorFluent<A>>
extends BaseFluent<A> {
    private List<String> matchNames = new ArrayList<String>();

    public NamespaceSelectorFluent() {
    }

    public NamespaceSelectorFluent(NamespaceSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NamespaceSelector instance) {
        NamespaceSelector namespaceSelector = instance = instance != null ? instance : new NamespaceSelector();
        if (instance != null) {
            this.withMatchNames(instance.getMatchNames());
            this.withMatchNames(instance.getMatchNames());
        }
    }

    public A addToMatchNames(int index, String item) {
        if (this.matchNames == null) {
            this.matchNames = new ArrayList<String>();
        }
        this.matchNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToMatchNames(int index, String item) {
        if (this.matchNames == null) {
            this.matchNames = new ArrayList<String>();
        }
        this.matchNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToMatchNames(String ... items) {
        if (this.matchNames == null) {
            this.matchNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToMatchNames(Collection<String> items) {
        if (this.matchNames == null) {
            this.matchNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromMatchNames(String ... items) {
        if (this.matchNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.matchNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMatchNames(Collection<String> items) {
        if (this.matchNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.matchNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getMatchNames() {
        return this.matchNames;
    }

    public String getMatchName(int index) {
        return this.matchNames.get(index);
    }

    public String getFirstMatchName() {
        return this.matchNames.get(0);
    }

    public String getLastMatchName() {
        return this.matchNames.get(this.matchNames.size() - 1);
    }

    public String getMatchingMatchName(Predicate<String> predicate) {
        for (String item : this.matchNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMatchName(Predicate<String> predicate) {
        for (String item : this.matchNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchNames(List<String> matchNames) {
        if (matchNames != null) {
            this.matchNames = new ArrayList<String>();
            for (String item : matchNames) {
                this.addToMatchNames(item);
            }
        } else {
            this.matchNames = null;
        }
        return (A)((Object)this);
    }

    public A withMatchNames(String ... matchNames) {
        if (this.matchNames != null) {
            this.matchNames.clear();
            this._visitables.remove((Object)"matchNames");
        }
        if (matchNames != null) {
            for (String item : matchNames) {
                this.addToMatchNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMatchNames() {
        return this.matchNames != null && !this.matchNames.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespaceSelectorFluent that = (NamespaceSelectorFluent)((Object)o);
        return Objects.equals(this.matchNames, that.matchNames);
    }

    public int hashCode() {
        return Objects.hash(this.matchNames, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchNames != null && !this.matchNames.isEmpty()) {
            sb.append("matchNames:");
            sb.append(this.matchNames);
        }
        sb.append("}");
        return sb.toString();
    }
}

